 library("hazreg") 
 n = 20
 p = 2
 beta = 1|2                         ; regression parameter
 z = 1 + uniform(n,p)               ; covariates
 y = -log(1-uniform(n))             ; exponential survival
 y = y./exp(z*beta)                 ; covariate effects
 c = 4*uniform(n)                   ; uniform censoring
 t = min(y~c,2)                     ; censored time             
 delta = (y<=c)                     ; censoring indicator            
 {data,ties} = hazdat(t,delta, z)   ; preparing data
 z1 = 1.1|1.23
 surv = hazsurv(data, z1)
 t = surv[2:n,1]
 s = surv[1:n-1,2]
 surv = ((surv[1:n-1,])|(t~s))|((t~s)|(surv[2:n,]))
 pm = (#(1,n)'+ (0:n-2))|(#(2*n-2,3*n-3)'+ (0:n-2))
 cn = matrix(2*n-2)                  ;  color_num, controls colors
 ar = matrix(2*n-2)                  ;  art, controls line types
 th = matrix(2*n-2)                  ;  thick, controls line thickness
 setmaskl(surv ,pm ,cn , ar, th)
 setmaskp(surv, 4, 0, 8) 
 setsize(600,400) 
 t1=createdisplay(1,1)  
 show(t1, 1, 1, surv)               
 setgopt(t1,1,1, "title","Conditional Survival Function","xlabel","Time","ylabel","Survival Function",  "ymajor", 0.2)
 print (t1,"hazsurvtest.ps") 
