; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         ls04
; ----------------------------------------------------------------------------
; Description   estimation of stacklos data set by OLS
;               with a residual plot
; ----------------------------------------------------------------------------
  library("metrics")
  library("graphic")
;
  z = read("stacklos")
;
  n = rows(z)
  x = matrix(n)~z[,2:4]
  y = z[,5]
;
  b = gls(x,y)
;
; residuals
;
  d = createdisplay(1,1)    
  yhat = x * b
  res = y - yhat
  sigma = sqrt(var(res))
  p = (1:n)~res
  l0 = gryline(0, #(0,n)) 
  l1 = gryline(sigma, #(0,n))
  l2 = gryline(-sigma, #(0,n))
  setmaskl(l1, (1:rows(l1))', 1, 1, 1) 
  setmaskl(l2, (1:rows(l2))', 1, 1, 1)
  l3 = gryline(3*sigma, #(0,n))
  l4 = gryline(-3*sigma, #(0,n))
  setmaskl(l3, (1:rows(l3))', 1, 1, 3)
  setmaskl(l4, (1:rows(l4))', 1, 1, 3)
  show (d, 1, 1, p, l0, l1, l2, l3, l4)
  title="LS residual plot - stackloss data"
  setgopt(d, 1, 1,"title",title) 
