; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      panstats panlag panfix pandyn panunit
; ----------------------------------------------------------------------------
; Macro         pantlet
; ----------------------------------------------------------------------------
; Description   application of panel data quantlets in XploRe to 
;		a macroeconomic data set
; ----------------------------------------------------------------------------
library("metrics")

z=read("uippanel.dat")
panstats(z)

z[,3]=log(z[,3])*100

y1=panlag(z,1)
y0=panlag(z,0)

z1=y0[,1:2]~(y0[,3]-y1[,3])~y0[,4]~y1[,5]

panfix(z1,2)
pandyn(z1,1,1)

panunit(z,2,1,1)
panunit(z,3,1,1)
