; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also     
; ----------------------------------------------------------------------------
; Macro         qr05
; ----------------------------------------------------------------------------
; Description   median regression, demonstration of nonrobustness
;               with respect to leverage points
; ----------------------------------------------------------------------------
  library("metrics")
;
  outlier = #(3,2)         ; outlying observation
;
; data initialization
;
  n = 10                   ; number of observations
  randomize(17654321)      ; sets random seed
  beta = #(1, 2)           ; intercept and slope
  x = matrix(n)~uniform(n) ; randomly generated data
  x = sort(x)
  x = x | (1~outlier[1])   ; add outlier
;
; generate regression line and noisy response variable
;
  regline = x * beta
  y = regline[1:n] + 0.05 * normal(n)
  y = y | outlier[2]       ; add outlier
;
  z = rqfit(x,y,0.5)       ; estimation
  betahat = z.coefs
;
; create graphical display and draw data points and regressions line
;
  d = createdisplay(1,1)     
  data = x[,2]~y           ; data points
  outl = outlier[1]~outlier[2]   ; outlier
  setmaskp(outl,1,12,15)         ;   is blue big star
;
  line = x[,2]~regline           ; true regression line
  setmaskp(line, 0, 0, 0)
  setmaskl(line, (1:rows(line))', 1, 1, 1)
;
  yhat = x * betahat
  qrline = x[,2]~yhat      ; estimated regression line
  setmaskp(qrline, 0, 0, 0)
  setmaskl(qrline, (1:rows(qrline))', 4, 1, 3)
;
; display all objects
;
  show(d, 1, 1, data[1:n], outl, line, qrline)
  setgopt(d, 1, 1, "title", "Quantile regression with outlier")
