; -----------------------------------------------------------------
; Library        QUANT
; -----------------------------------------------------------------
;   Macro        quant02
; -----------------------------------------------------------------
;   Description  Example quantlet, which generates a regression line, 
;                adds random noise, and plots.
; -----------------------------------------------------------------
    n = 10                           ; number of observations
    randomize(17654321)              ; sets random seed
    beta = # (1, 2)                  ; defines intercept and slope
    x = matrix(n)~sort(uniform(n))   ; creates design matrix     
    m = x*beta                       ; defines regression line
    eps = 0.05*normal(n)             ; creates obs error
    y = m + eps                      ; noisy line
    d = createdisplay(1,1)      
    dat = x[,2]~y
    show(d, 1, 1, dat)