; ----------------------------------------------------------------------------
; Library       xag
; ----------------------------------------------------------------------------
; See_also      kfilter2 calibrIC rICfil
; ----------------------------------------------------------------------------
; Macro         rkalm07
; ----------------------------------------------------------------------------
; Description   calculates classical Kalman filter and rIC filter for 
;		data with additive outliers
; ----------------------------------------------------------------------------
library("xplore")
library("plot")
library("kalman")
serie = read("kalmanao.dat")
y = serie[,2]
mu = 10
Sig = 0
H = 1
F = 1
Q = 9
R = 9
T=dim(y)

e=0.05
N=100
eps=0.01
itmax=15
aus=4
fact=1.2
expl=2
A0=0     
b0=-1    
typ= 0   


ergIC=calibrIC(T,Sig,H,F,Q,R,typ,A0,b0,e,N,eps,itmax,expl,fact,aus)

A=ergIC.A
b=ergIC.b

res = kfilter2(y,mu,Sig, H,F,Q,R)
fx = res.filtX
res= rICfil(y,mu,Sig,H,F,Q,R,typ,A,b)
frx = res.filtX

origy= serie[,1]~serie[,2]
origy= setmask(origy, "line", "blue", "thin")
fx = serie[,1]~fx
fx = setmask(fx, "line", "red", "thin")
frx = serie[,1]~frx
frx = setmask(frx, "line", "green", "thin")
clip=serie[,1]~(res.clipInd)
clip=paf(clip,clip[,2]==1)
clip[,2]=0
setmaskp(clip,4, 3, 4)  

disp = createdisplay(1,1)
show(disp,1,1, origy,fx,frx,clip)
setgopt(disp,1,1, "title", "KalmanData1 + AO's in t=50,60,90")
setgopt(disp,1,1, "xlabel", "t") 
setgopt(disp,1,1, "ylabel", "y, rIC-sim, Kalman") 
