; -----------------------------------------------------------------
; Library        SMOO
; -----------------------------------------------------------------
;   Macro        smoo13
; -----------------------------------------------------------------
;   Description  Computes a two-dimensional density estimate and 
;                plots the surface in 3D.
; -----------------------------------------------------------------
  library("smoother")
  library("plot")
  setsize(640,480)
;
  geyser = read("geyser") 
  fh = denxestp(geyser) 
  fh = setmask(fh,"surface","blue")
  axesoff()
  cu = grcube(fh)              ; box
  plot(cu.box,cu.x,cu.y, fh)   ; plot box and fh
  setgopt(plotdisplay,1,1,"title","2D Density Estimate")
  axeson()


