proc(H)=RShurst(x)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    RSteiler, Varplot
; ---------------------------------------------------------------------
; Macro       RShurst
; ---------------------------------------------------------------------
; Description Calculation of a matrix of the mean of R/S for selected k
;							and estimation of H
; ---------------------------------------------------------------------
; Usage       (H)=RShurst(x)
; Input       
; Parameter   x series to be estimated
; Definition  
; Output      
; Parameter   H	estimated Hurst coefficient
; Definition  
; ---------------------------------------------------------------------
; Notes       needs library "stats"
; ---------------------------------------------------------------------
; Example    	x=normal(500)
;						 	RS=RShurst(x)
; ---------------------------------------------------------------------
; Result      Contents of H
;							[1,]  0.54455
; ---------------------------------------------------------------------
; Keywords    self similarity, long memory
; ---------------------------------------------------------------------
; Reference   Peters, E.E. "Fractal Market Analysis: Applying Chaos
;							Theory to Investment and Economics" Wiley, New York 1994
;							Beran, J. "Statistics for Long Memory Processes" Chapman
;							& Hall 1994
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wuensche 000410
; ---------------------------------------------------------------------
//
n=rows(x)
teiler=RSteiler(x)
m=rows(teiler)
i1=0
rsa=matrix(m,2)
while (i1<m)
  i1=i1+1
  i2=0
  rs=matrix(floor(n/teiler[i1]))
  while(i2<floor(n/teiler[i1]))
        i2=i2+1
        i3=0
        xk=matrix(teiler[i1])
        while (i3<teiler[i1])
              i3=i3+1
              xk[i3]=x[(i2-1)*teiler[i1]+i3]
        endo
        i4=0
        xs=matrix(teiler[i1])
        z=matrix(teiler[i1])
        while (i4<teiler[i1])
              i4=i4+1
              xs[i4]=(xk[i4]-mean(xk))^2
              z[i4]=xk[i4]-mean(xk)
        endo
        i5=1
        y=matrix(teiler[i1])
        y[1]=z[1]
        while (i5<teiler[i1])
              i5=i5+1
              y[i5]=z[i5]+y[i5-1]
        endo
  r=max(y)-min(y)
  s=sqrt(sum(xs)/teiler[i1])
  rs[i2]=r/s    
  endo
rsa[i1,1]=log(teiler[i1])
rsa[i1,2]=log(mean(rs))   
endo
{b,bse,bstan,pval}=linreg(rsa[,1],rsa[,2])
H=b[2]
endp         