proc()=Vstat(x)
; ---------------------------------------------------------------------
; Library     
; ---------------------------------------------------------------------
; See_also    Variogram, Varplot, RShurst
; ---------------------------------------------------------------------
; Macro       Vstat2
; ---------------------------------------------------------------------
; Description Plotting of the V-statistic (V=(R/S)/sqrt(n)) and an
;							calculated curve for an independent sample by a formula
;							for the expected Hurst Coefficient by Anis and Lloyd if
;							series is independent
; ---------------------------------------------------------------------
; Usage       ()=Vstat(x)
; Input       
; Parameter   x
; Definition  
; Output      Plot
; ---------------------------------------------------------------------
; Notes       
; ---------------------------------------------------------------------
; Example     x=normal(1000)
;							Vstat(x)
; ---------------------------------------------------------------------
; Result      <graphic>
; ---------------------------------------------------------------------
; Keywords    
; ---------------------------------------------------------------------
; Reference   Peters, E.E. "Fractal Market Analysis: Applying Chaos
;							Theory to investment and economics" Wiley, New York,
;							page 92
;							Anis, A.A., Lloyd, E.H., "The expected Value of the
;							Adjusted Rescaled Hurst Range of Independent Normal
;							Summands", Biometrica 63, 1976 
; ---------------------------------------------------------------------
; Link        
; ---------------------------------------------------------------------
; Author      Arne Wuensche 000410
; ---------------------------------------------------------------------
//
n=rows(x)
a0=5
a=a0-1
teiler1=matrix(n/4)
j=0
i=0
while(a<=floor(n/4))
  a=a+1
    if (floor(n/(a+1))<floor(n/a))
      j=j+1
      teiler1[j]=a
    endif
endo
teiler=matrix(j) 
do 
  i=i+1
  teiler[i]=teiler1[i]
until (i>=j)
;
m=rows(teiler)
i1=0
rsa=matrix(m,2)
while (i1<m)
  i1=i1+1
  i2=0
  rs=matrix(floor(n/teiler[i1]))
  while(i2<floor(n/teiler[i1]))
        i2=i2+1
        i3=0
        xk=matrix(teiler[i1])
        while (i3<teiler[i1])
              i3=i3+1
              xk[i3]=x[(i2-1)*teiler[i1]+i3]
        endo
        i4=0
        xs=matrix(teiler[i1])
        z=matrix(teiler[i1])
        while (i4<teiler[i1])
              i4=i4+1
              xs[i4]=(xk[i4]-mean(xk))^2
              z[i4]=xk[i4]-mean(xk)
        endo
        i5=1
        y=matrix(teiler[i1])
        y[1]=z[1]
        while (i5<teiler[i1])
              i5=i5+1
              y[i5]=z[i5]+y[i5-1]
        endo
  r=max(y)-min(y)
  s=sqrt(sum(xs)/teiler[i1])
  rs[i2]=r/s    
  endo
rsa[i1,1]=log(teiler[i1])
rsa[i1,2]=(mean(rs))   
endo        
;
i=0
Ers=matrix(m,2)
V=matrix(m,2)
while (i<m)
      i=i+1
      j=0
      summe=0
      while (j<teiler[i])
            j=j+1
            summe=summe+sqrt((teiler[i]-j)/j)
      endo
      Ers[i,1]=log(teiler[i])
      Ers[i,2]=(exp(lgamma((teiler[i]-1)/2)-log(sqrt(pi))-lgamma(teiler[i]/2))*summe)/sqrt(teiler[i])
      V[i,1]=log(teiler[i])
      V[i,2]=(rsa[i,2])/sqrt(teiler[i])
endo
c=createdisplay(1,1)
z1=setmask(V,"line")
z2=setmask(Ers,"line","blue","thin","solid")
z3=setmask(V,8)
z4=setmask(Ers,6)
show(c,1,1,z1,z2,z3,z4)
setgopt(c,1,1,"xlabel","log(k)","ylabel","V-statistik")          
endp