proc(opvv,sel,ingred)=bs1(task)
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       mcmillan
; -----------------------------------------------------------------
;   Macro         bs1
; -----------------------------------------------------------------
;   Description   calculates option prices 
;                 using the Black and Scholes formula
; -----------------------------------------------------------------
;   Usage         {opvv,sel,ingred} = bs1(task)
;   Input         
;     Parameter   task  
;     Definition      scalar: (=1) - without dividend, (=2) - with
;                             continuously paid dividend, (=3) - 
;                             with a fixed dividend at the end of T,
;                             (=4) - if for exchange rate
;   Output        
;     Parameter   opvv  
;     Definition      scalar , value of the option
;     Parameter   sel  
;     Definition      2 x 1 vector ,  if sel[1]=1 'call', else 'put' 
;     Parameter   ingred  
;     Definition      6 x 1 vector , stock price, strike price,
;                                    time of expiration, volatility, 
;                                    domain interest rate, dividend
;   
; -----------------------------------------------------------------
;   Example   library("finance")
;             bs1(1)
; -----------------------------------------------------------------
;   Result    option price using Black and Scholes formula
; -----------------------------------------------------------------
;   Notes	    See optstart
; -----------------------------------------------------------------
;   Author    Feldmann, Sperlich  970130 
; -----------------------------------------------------------------
; input of basic determinants
valuestrs1 = "Price of Underlying Asset"|"Exercise Price"|"Domestic Interest Rate per Year (%)"|"Volatility per Year (%)"|"Time to Expiration (Years)"
if (exist("v1")==0)
  v1=230|210|5.0|25.0|0.5
endif
values1=v1
v1=readvalue(valuestrs1,values1)
	s=v1[1]			;stock price
	k=v1[2]			;exercise price	
	r=log(0.01*v1[3]+1)	;rate of interest
	sigma=0.01*v1[4]	;volatility
	t=v1[5]			;time to expiration
; input additional parameter
q = 0		;definition of variable to avoid error if task 1 is chosen		
values2=0
values3=0 
values4=0 
if(task)
	switch
	case(task==2)	valuestrs2 = "Dividend (Year,%)" 
			q=readvalue(valuestrs2, values2)
			q=log(0.01*q+1)
			break
	case(task==3)	valuestrs3 = "Dividend (fixed amount)" 
			q=readvalue(valuestrs3, values3)
                        q=s*(1+v1[3]*0.01)/(s*(1+v1[3]*0.01)-q) -1
			q=log(q+1)
			break
	case (task==4)  valuestrs4 = "Foreign Interest Rate (Year,%)" 
			q=readvalue(valuestrs4, values4)
			q=log(0.01*q+1)
			break
	endsw
endif
;;;;;;;;;;;;;;;;;;black-scholes formula  
y = (log(s/k)+(r-q-sigma^2/2)*t)/(sigma*sqrt(t))
  selhead = "What Kind of Option do You have?"
sel = 0|0
do 
  selitem = "Call"|"Put" 
      sel = selectitem (selhead, selitem)
      if (sel[1])
	  opv = s*exp(-q*t)*cdfn(y+sigma*sqrt(t))-k*exp(-r*t)*cdfn(y)
          sent=" The Price of Your European Call-Option "
      endif 
      if (sel[2])
	  opv = k*exp(-r*t)*cdfn(-y)-s*exp(-q*t)*cdfn(-y-sigma*sqrt(t))
	  sent=" The Price of Your European Put-Option " 
      endif
until (sum(sel)==1)
;option prices can't be negative
  if(opv<0)
	opv=0
  endif	
;;;;;;;;;;;;;;;;;;;;;output
  if (task)	
		switch
		case(task==1) ence=" on Given Stock is " 
		break
		case(task==2) ence=" on Given Stock with cont. Dividends is" 
		break
		case(task==3) ence=" on Given Stock with fixed Dividend is" 
		break
		case(task==4) ence=" on Foreign Exchange is" 
		break
		endsw
  endif	
 ingred = s|k|t|sigma|r|q
 opvv=opv
 opv = string("%4.4f",opv)
 lin=("-------------------------------------")
 aus= " "|lin|sent|ence|opv|lin|" "  
 aus
endp
