proc (z) = ccosh(x)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     ccos cexp cln csin csinh ctan ctanh csqrt
; -----------------------------------------------------------------------
; Macro        ccosh
; -----------------------------------------------------------------------
; Description  Complex hyperbolic cosine
; -----------------------------------------------------------------------
; Usage        z = ccosh (x)
; Input
;   Parameter  x 
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              z = complex (3.14515/2, 0)
; 	       ccosh (z)
; -----------------------------------------------------------------------
; Result       Contents of z.re 
;              [1,]   2.5133 
;              Contents of z.im
;              [1,]        0 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960327, 970529
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "ccosh : No real part in x found")
  error (comp(x, "im")<1, "ccosh : No imaginary part in x found")
  re =  cosh(x.re) .* cos(x.im)
  im = -sinh(x.re) .* sin(x.im)
  z  = list(re, im)
endp

