proc(ret)=cdfbin(n,p,x)
; -----------------------------------------------------------------------
; Library      stats
; -----------------------------------------------------------------------
; See_also     pdfbin, qfbin, randbin
; -----------------------------------------------------------------------
; Macro        cdfbin
; -----------------------------------------------------------------------
; Description  computes the cumulative distribution function of a 
;              binomial distribution
; -----------------------------------------------------------------------
; Usage        p = cdfbin (n, p, x)
; Input        
;   Parameter  n
;   Definition scalar parameter of binomial distribution
;   Parameter  p
;   Definition scalar parameter of binomial distribution
;   Parameter  x
;   Definition m x 1 vector of integer number (0<=x<=n)
; Output       
;   Parameter  ret
;   Definition m x 1 vector of cumulative probabilities
; -----------------------------------------------------------------------
; Example      library ("stats")
;              cdfbin(20, 0.1, 0:20)  
; -----------------------------------------------------------------------
; Result    Contents of ret
;           [ 1,]  0.12158 
;           [ 2,]  0.39175 
;           [ 3,]  0.67693 
;           [ 4,]  0.86705 
;           [ 5,]  0.95683 
;           [ 6,]  0.98875 
;           [ 7,]  0.99761 
;           [ 8,]  0.99958 
;           [ 9,]  0.99994 
;           [10,]  0.99999 
;           [11,]        1 
;           [12,]        1 
;           [13,]        1 
;           [14,]        1 
;           [15,]        1 
;           [16,]        1 
;           [17,]        1 
;           [18,]        1 
;           [19,]        1 
;           [20,]        1 
;           [21,]        1     
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 980827
; -----------------------------------------------------------------------
  ret  = 0*x
  i    = 0
  prob = pdfbin(n,p,0:n)
  while (i<rows(x))
    i=i+1
    switch
    case (x[i]<0)
      ret[i] = 0
      break
    case (x[i]>n)
      ret[i] = 1
      break
    default
      ret[i] = sum(prob[1:(x[i]+1)])
    endsw
  endo
endp
