proc (z) = cexp (x) 
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     ccos ccosh cln csin csinh ctan ctanh csqrt
; -----------------------------------------------------------------------
; Macro        cexp
; -----------------------------------------------------------------------
; Description  Complex exponential
; -----------------------------------------------------------------------
; Usage        z = cexp (x)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              z = complex (0, 3.1415/2)
;              cexp (z)
; -----------------------------------------------------------------------
; Result       Contents of z.re
;		           [1,]  4.6327e-05
;              Contents of z.im
; 		         [1,]        1
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 960401, 970529
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "cexp : No real part in x found")
  error (comp(x, "im")<1, "cexp : No imaginary part in x found")
  re = exp(x.re) .* cos(x.im) 
  im = exp(x.re) .* sin(x.im) 
  z  = list(re,im)
endp 


