proc(selvar)=choosevariablep(datap,coltype)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     choosegroup choosevarable2 choosevariablep 
;              choosevariableY doista regressionplots
; -----------------------------------------------------------------------
; Macro        choosevariablep
; -----------------------------------------------------------------------
; Description  selction of variables in regression context  
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  if(sum(datap.colvarp&&coltype&&datap.colmissingp))
    ;variables to choose have to be undeleted
    selheadh="Select variable(s)"
    selitemh = paf(datap.colnamep, (datap.colvarp && coltype && datap.colmissingp))
    selitemh="all"|selitemh
    selind = paf(1:rows(datap.colnamep), (datap.colvarp && coltype && datap.colmissingp))
    selvar = 0.*matrix(rows(datap.colnamep))
    sel = selectitemlist(selheadh,selitemh,15)
    r=rows(sel)
    if (sel[1]==1) 
      selvar[selind]=1*matrix(r-1)
    else
      selvar[selind] = sel[2:r]
    endif
  else
    selvar = 0.*matrix(cols(datap.colnamep))
  endif
endp  