proc(coeff)=coeffest(ord,di,tb,te,adj,typ,ytt)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      ymulz zmulz
; -----------------------------------------------------------------
;   Macro         coeffest
; -----------------------------------------------------------------
;   Description   estimates the coefficients of a full VAR model
; -----------------------------------------------------------------
;   Usage         coeff = coeffest(ord,di,tb,te,adj,typ,ytt) 
;   Input
;     Parameter   ord 
;     Definition    integer, order of series
;     Parameter   di 
;     Definition    integer, dimension of time series
;     Parameter   tb 
;     Definition    integer, (time) begin 
;     Parameter   te 
;     Definition    integer, (time) end
;     Parameter   adj 
;     Definition    integer, adjusted (1) or not (0) 
;     Parameter   typ 
;     Definition    integer, describing the model type
;     Parameter   ytt
;     Definition    vector, the transformed time series
;   Output
;     Parameter   coeff
;     Definition     matrix, the estimated coefficients
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich  971027
; -----------------------------------------------------------------
 if ((ord==0) && (adj==1))
   coeff=0
 else
   coeff=ymulz(ord,di,tb,te,adj,typ,ytt)*inv(zmulz(ord,di,tb,te,adj,0,typ,ytt))
 endif
endp
