proc(output)=collinearity(x,Vin) 
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista confidenceb confidency covmatrix descriptivelinreg
;              durbinwatson regressionstatistic
; -----------------------------------------------------------------------
; Macro        collinearity
; -----------------------------------------------------------------------
; Description  performs a collineatity diagnostic after regression 
;              analysis and shows the eigenvalues and condition indices
;              of the independent variables 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  ind=0.*matrix(cols(x))
  ind[Vin]=1
  x=(paf(x',ind))'
  m = mean(x)
  n = cols(x)
  c = corr(x)
  {lambda, gamma}=eigsm(c)  
  lambda=sort(lambda,-1)
  l=max(lambda)
  phi=sqrt(l./lambda )
  firstline="Collinearity Diagnostics"
  secondline="---------------------------------"
  thirdline="Number   Eigenvalues   Cond Index "   
  fourthline="---------------------------------"
  phistr=string("%10.3f",phi)
  lambdastr=string("%11.3f   ",lambda)
  nstr=string("%6.0f   ",1:rows(lambda))
  output=firstline|secondline|thirdline|fourthline|(nstr+lambdastr+phistr)
endp





