proc(thePoints)=colorcube()
; ---------------------------------------------------------------------
; Library     graphic 
; ---------------------------------------------------------------------
; See_also    freecolor createcolor setmaskp
; ---------------------------------------------------------------------
; Macro       colorcube
; ---------------------------------------------------------------------
; Description Displays a multi-color cube
; ---------------------------------------------------------------------
; Usage       (points)=colorcube()
; Input       
; Output  
; Parameter   points
; Definition  List of points and lines forming the color cube.    
; ---------------------------------------------------------------------
; Notes       Calls freecolor() and createcolor() to allocate the
;             colors for the cube.
; ---------------------------------------------------------------------
; Example     library("graphic")
;             points = colorcube()
;             dd = createdisplay(1, 1)
;             show(dd, 1, 1, points)
; ---------------------------------------------------------------------
; Result      Displays a cube. Use the arrow keys to turn the cube.
; ---------------------------------------------------------------------
; Keywords    color
; ---------------------------------------------------------------------
; Author      Stephan R. W. Lauer, 990301
; ---------------------------------------------------------------------


// create bounding lines for better perception of the cube
thePoints = ( 0 ~ 0 ~ 0 )
thePoints = thePoints | ( 5 ~ 0 ~ 0 )
thePoints = thePoints | ( 5 ~ 5 ~ 0 )
thePoints = thePoints | ( 0 ~ 5 ~ 0 )
thePoints = thePoints | ( 0 ~ 0 ~ 5 )
thePoints = thePoints | ( 5 ~ 0 ~ 5 )
thePoints = thePoints | ( 5 ~ 5 ~ 5 )
thePoints = thePoints | ( 0 ~ 5 ~ 5 )

theLines = ( 1 ~ 2 )
theLines = theLines | ( 2 ~ 3 )
theLines = theLines | ( 3 ~ 4 )
theLines = theLines | ( 4 ~ 1 )
theLines = theLines | ( 5 ~ 6 )
theLines = theLines | ( 6 ~ 7 )
theLines = theLines | ( 7 ~ 8 )
theLines = theLines | ( 8 ~ 5 )
theLines = theLines | ( 1 ~ 5 )
theLines = theLines | ( 2 ~ 6 )
theLines = theLines | ( 3 ~ 7 )
theLines = theLines | ( 4 ~ 8 )

// then create all the points and colors
i = 0
theColor = (0 ~ 0 ~ 0)
theColor = theColor | ( 0 ~ 0 ~ 0 )
theColor = theColor | ( 0 ~ 0 ~ 0 )
theColor = theColor | ( 0 ~ 0 ~ 0 )
theColor = theColor | ( 0 ~ 0 ~ 0 )
theColor = theColor | ( 0 ~ 0 ~ 0 )
theColor = theColor | ( 0 ~ 0 ~ 0 )
theColor = theColor | ( 0 ~ 0 ~ 0 ) // the first eight points are for the lines
                                    // and have no color
                                    
thePointType = 0 .* matrix(8)

while (i<6)
   j = 0
   while (j<6)
      k = 0
      while (k<6)
          thePoints = thePoints | ( i ~ j ~ k )
          theColor = theColor | ( i*50 ~ j*50 ~ k*50 )
          thePointType = thePointType | 8       // filled circle
      k = k + 1
      endo
   j = j + 1
   endo
i = i + 1
endo

freecolor()
createcolor(theColor)

setmaskp(thePoints, theColor, thePointType, 15)
setmaskl(thePoints, theLines, 0, 2, 2) // but with lines


endp
