proc(cov)=covbrr(b,ew,r,j,l,icovp,diord)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     modelrr, estabr, covarr, covabc, covabrr 
; -----------------------------------------------------------------
;   Macro        covbrr
; -----------------------------------------------------------------
;   Description  Covariance matrix B, reduced rank VAR Model
; -----------------------------------------------------------------
;   Usage        cov=covbrr(b,ew,r,j,l,icovp,diord)  
;   Input
;     Parameter   b  
;     Definition      matrix of parameters
;     Parameter   ew
;     Definition      matrix of eigenvalues    
;     Parameter   r
;     Definition      integer, rank of VAR model
;     Parameter   j 
;     Definition      integer, index
;     Parameter   l 
;     Definition      integer, index
;     Parameter   icovp 
;     Definition      matrix
;     Parameter   diord
;     Definition      integer, (dimension * order)
;   Output
;     Parameter   cov
;     Definition     matrix 
; -----------------------------------------------------------------
;   Author    TP A1/A2, CH 980408
; -----------------------------------------------------------------
cov = zeros(diord,diord);
if (j==l)
   k=1;
  while (k<=r)
      if (k<>j)
         cov = cov+(3*ew[j,1]-ew[k,1])/((ew[j,1]-ew[k,1])^2)*b[k,]'*b[k,]
      endif
      k=k+1
   endo
   cov=cov+icovp
endif
if (j<>l)
    cov = -(ew[j,1]+ew[l,1])/((ew[j,1]-ew[l,1])^2)*b[l,]'*b[j,]
endif
endp
