proc(gh)=covmwgen(covu,coeff,ord,di,adj,h,typ)
; -----------------------------------------------------------------
;   Library       multi
; -----------------------------------------------------------------
;   See_also      coeffest
; -----------------------------------------------------------------
;   Macro         covmwgen
; -----------------------------------------------------------------
;   Description   generates covariance matrix of the mean in VAR
; -----------------------------------------------------------------
;   Usage         gh = covmwgen(covu,coeff,ord,di,adj,h,typ) 
;   Input
;     Parameter   covu 
;     Definition    matrix, covariance
;     Parameter   coeff 
;     Definition    matrix, estimated coefficients
;     Parameter   ord 
;     Definition    integer, order of series
;     Parameter   di 
;     Definition    integer, dimension of time series
;     Parameter   adj 
;     Definition    integer, 1=if adjusted, 0=if not
;     Parameter   h 
;     Definition     integer, forecast horizon
;     Parameter   typ 
;     Definition    integer, describing the model type
;   Output
;     Parameter   gh
;     Definition     matrix, covariance matrix
; -----------------------------------------------------------------
;   Author    Hafner, Sperlich  971203
; -----------------------------------------------------------------
 if (adj == 1)
  gh = kron( ones(h,1), covu )
else
  gh=0
endif
if ( (adj == 1) .* (ord .>0) )
  eye1=eye(di)
  eyep=kron( ones(ord,1),eye1 )
  covmw= inv(eye1-coeff[1:di,]*eyep)
  covmw=covmw*covu*covmw'
  jota=jagen(di,ord,typ)
  gh=zeros(1,di)
  i=1
  while (i<=h)
     g=eye1-jota*power(coeff,i)*eyep
     gh=gh|(g*covmw*g')
     i=i+1
  endo
  gh=gh[2:rows(gh),]
endif
endp
