proc(covr)=covres(ord,di,tb,te,adj,typ,ytt)
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  domulti
; ----------------------------------------------------------------------
;   Macro	  covres
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for full VAR models 
; ----------------------------------------------------------------------
;   Usage         covr = covres(ord,di,tb,te,adj,typ,ytt)
;   Input 
;     Parameter   ord 
;     Definition    integer, order of series
;     Parameter   di 
;     Definition    integer, dimension of time series
;     Parameter   tb 
;     Definition    integer, (time) begin 
;     Parameter   te 
;     Definition    integer, (time) end
;     Parameter   adj 
;     Definition    integer, 1=if adjusted, 0=if not
;     Parameter   typ 
;     Definition    integer, describing the model type
;     Parameter   ytt
;     Definition    vector, the transformed time series
;   Output
;     Parameter   covr
;     Definition     matrix
; ----------------------------------------------------------------------
;   Author        Hafner, Sperlich 971204
; ---------------------------------------------------------------------- 
 yz=ymulz(ord,di,tb,te,0,typ,ytt)
 zz=zmulz(ord,di,tb,te,0,0,typ,ytt)
 covr=1/(te-tb-di*ord)*(ytt[,tb:te]*ytt[,tb:te]'-yz*inv(zz)*yz')
endp
