proc (z) = csort(x, c)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     csortcol
; -----------------------------------------------------------------------
; Macro        csort
; -----------------------------------------------------------------------
; Description  csort sorts the rows of a complex matrix with respect 
; 	to the absolute value of the complex numbers. If a column c is 
;	specified the rows of the matrix will be ordered with respect 
;	to the elements of column c in ascending (descending) order.
; -----------------------------------------------------------------------
; Usage        z = csort(x c)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
;   Parameter  c
;   Definition scalar   column of x
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              x = complex (#(1,2)~#(3,2), #(1,2)~#(1,1))
;	             c  = 2
;	             csort(x, c)
; -----------------------------------------------------------------------
; Result       
;	  Contents of z.re
;	  [1,]        2        2 
;   [2,]        1        3 
;	  Contents of z.im
;	  [1,]        2        1 
;   [2,]        1        1 
; -----------------------------------------------------------------------
; Keywords     complex numbers, sorting
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 970529, Susanne Hannappel, 960423
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "csort : No real part in x found")
  error (comp(x, "im")<1, "csort : No imaginary part in x found")
  b  = cols (x.re)
  s  = x.re^2 + x.im^2
  s  = sort (s~x.re~x.im, c)
  re = s[,(b+1):(2*b)]
  im = s[,(2*b+1):(3*b)]
  z  = list(re,im)
endp


