proc (z) = ctan (x)
; -----------------------------------------------------------------------
; Library      math
; -----------------------------------------------------------------------
; See_also     ccos, ccosh, cexp, cln, csin, csinh, csqrt, ctanh 
; -----------------------------------------------------------------------
; Macro        ctan 
; -----------------------------------------------------------------------
; Description  Complex tangens 
; -----------------------------------------------------------------------
; Usage        z = ctan(x)
; Input
;   Parameter  x
;   Definition n x p x d1 x ... x dn complex array
; Output
;   Parameter  z
;   Definition n x p x d1 x ... x dn complex array
; -----------------------------------------------------------------------
; Example      library("math")
;              x = complex (#(4,16), #(9,1))
;	             z = ctan(x)
; -----------------------------------------------------------------------
; Result       Contents of z.re
;	             [1,]  3.0136e-08 
;              [2,]  0.11997 
;	             Contents of z.im
; 		         [1,]        1 
;              [2,]  0.78906 
; -----------------------------------------------------------------------
; Keywords     complex numbers
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 920424, 970529, Susanne Hannappel, 960423
; -----------------------------------------------------------------------
  error (comp(x, "re")<1, "ctan : No real part in x found")
  error (comp(x, "im")<1, "ctan : No imaginary part in x found")
  r  = 2 * (cos(x.re)^2 + sinh(x.im)^2)
  re = sin(2*x.re)./r
  im = sinh(2*x.im)./r
  z  = list(re,im)
endp



