proc(data)=deletevariable(datain)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     doista istadata
; -----------------------------------------------------------------------
; Macro        deletevariable
; -----------------------------------------------------------------------
; Description  deletes selected variables from the data set
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  data=datain
  colv=string("%-10.10s",data.colname )
  ;colv=substr(colv,1,10)
  selhead="Choose variables"
  deletestr=string(" ",1:rows(data.colname))
  if(sum(1-data.colvar)==0)           
  ;all variables included
    deletestr=string(" included",1:rows(data.colname)) 
  else                                
  ;some variables excluded
    selk=paf(1:rows(data.colname),(data.colvar==0)) 
    deletestr[selk]=string(" excluded",data.colvar[selk])
    selk1=paf(1:rows(data.colname),(data.colvar==1)) 
    selk1
    deletestr[selk1]=string(" included",data.colvar[selk1]) 
  endif
  selitem=colv+deletestr
  sel= selectitemlist(selhead,selitem,15)
  data.colvar = ((sel||data.colvar)<>(sel&&data.colvar))
endp