proc (r) = dpgpdiag (x, k)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      dpgp
; -----------------------------------------------------------------
;   Macro         dpgpdiag
; -----------------------------------------------------------------
;   Description   Vector of Drees-Pickands estimator for GP model
; -----------------------------------------------------------------
;   Usage         r = dpgpdiag (x, k)
;   Input
;     Parameter   x
;     Definition      vector
;     Parameter   k
;     Definition      vector, number of exceedances
;   Output
;     Parameter   r
;     Definition      vector with shape parameters
; -----------------------------------------------------------------
;   Example   library("finance")
;	            x=randx("gp",100,1)
;             r=dpgpdiag(x,4:100)
;             r 
; -----------------------------------------------------------------
;   Result    Vector with estimated shape parameter for all number of
;             extremes provided in k
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  n = rows (x)
  error (n < 4, "Data set must have at least 4 elements")
  m = rows (k)
  i = 1
  x = sort (x)
  while (i <= m)
    error (k [i] < 4 || k [i] > n, "Invalid number of extremes (4 <= k <= n)")
    if (i == 1)
      r = dpgpgamma (x, k [i])
    else
      r = r | dpgpgamma (x, k [i])
    endif
    i = i + 1
  endo
endp
