proc (mu, sigma) = fittail (gamma, t, sigmas, k, n)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      dpgp pickandsgp momentgp mlegp
; -----------------------------------------------------------------
;   Macro         fittail
; -----------------------------------------------------------------
;   Description   transforms location and scale parameter of GP
;                 distribution from fit to exceedances to tail fit.
; -----------------------------------------------------------------
;   Usage         {mu, sigma} = fittail (gamma, t, sigmas, k, n)
;   Input
;     Parameter   gamma
;     Definition      scalar, shape parameter
;     Parameter   t
;     Definition      scalar, truncation point
;     Parameter   sigmas
;     Definition      scalar, scale parameter of exceedances
;     Parameter   n
;     Definition      integer, total sample size
;     Parameter   k
;     Definition      integer, number of exceedances
;   Output
;     Parameter   mu
;     Definition      scalar, transformed location parameter
;     Parameter  sigma
;     Definition      scalar, transformed scale parameter
; -----------------------------------------------------------------
;   Notes	Used internally by GP estimators
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  sigma = sigmas * (k / n) ^ gamma
  mu = t - (sigmas - sigma) / gamma
endp  