proc(gam)=gammaci(dy,yp,d,c,ord,b,e,di);
; ----------------------------------------------------------------------
; Library 	  multi
; ----------------------------------------------------------------------
;  See_also	  modelci
; ----------------------------------------------------------------------
;   Macro	  gammaci
; ----------------------------------------------------------------------
;   Description   auxiliary quantlet for cointegration
; ----------------------------------------------------------------------
;   Usage         gam=gammaci(dy,yp,d,c,ord,b,e,di)
;   Input 
;     Parameter   dy 
;     Definition     matrix, differenced time series
;     Parameter   yp 
;     Definition     matrix, submatrix of time series
;     Parameter   d 
;     Definition     matrix 
;     Parameter   c 
;     Definition     matrix 
;     Parameter   ord 
;     Definition     integer, order of series 
;     Parameter   b 
;     Definition     matrix 
;     Parameter   e 
;     Definition     vector 
;     Parameter   di 
;     Definition     integer, dimension of time series
;   Output
;     Parameter   gam
;     Definition     matrix, covariance matrix
; ----------------------------------------------------------------------
;   Author        Christian Hafner, Stefan Sperlich 971215
; ---------------------------------------------------------------------- 
   gam=dy[,b:e]+d*c*yp;
  gam=yzci(dy,gam,ord,b,e,di)*inv(zzgenci(dy,ord,b,e,di));
endp;
