proc(y)=gauder(x, h, p)
; -----------------------------------------------------------------
; Library        smoother
; -----------------------------------------------------------------
;  See_also      dengau
; -----------------------------------------------------------------
;   Macro        gauder
; -----------------------------------------------------------------
;   Description  gauder evaluates derivatives of the Gaussian 
;                kernel rescaled by a bandwidth h, to be used for
;                density estimation bandwidth selection.
; -----------------------------------------------------------------
;   Reference    Aldershof, Marron, Park and Wand (1990): Facts about
;                the Gaussian probability density function                      
; -----------------------------------------------------------------
;   Usage        y = gauder (x, h, p)
;   Input
;     Parameter  x  
;     Definition n x 1 vector
;     Parameter  h  
;     Definition scalar, bandwidth
;     Parameter  p  
;     Definition scalar, order of derivative
;   Output
;     Parameter  y  
;     Definition n x 1 matrix, Gaussian density derivatives
; -----------------------------------------------------------------
;   Example   library("smoother")                                       
;             x = aseq(-1, 21, 0.1)                                      
;             y = gauder(x,1,3)                                
;             t = createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                      
; -----------------------------------------------------------------
;   Result    plot the third normal derivative, bandwidth = 1                                                           ; -----------------------------------------------------------------
;   Author    Lijian Yang, 960820   
; -----------------------------------------------------------------
   x=x./h
   h1=0
   h0=matrix(rows(x))
   r=1

 if (p .= 2.*floor(p./2))
     pstop = p
   while (r<pstop)
     h1=x.*h0-(r-1).*h1
     h0=x.*h1-r.*h0
     r=r+2
   endo
    y=h0.*pdfn(x)./(h)^(p+1)
 else
     pstop = p+1
  while (r<pstop)
     h1=x.*h0-(r-1).*h1
     h0=x.*h1-r.*h0
     r=r+2
  endo
   y=(-1).^((p-1)./2).*h1.*pdfn(x)./(h)^(p+1)   ; formula (2.7) in AMPW (1990)
 endif

endp
