proc(w, u, m, netid)=gennet(ui, uo, ran, vn)               
; -----------------------------------------------------------------------
; Library      nn
; -----------------------------------------------------------------------
; See_also     ann
; -----------------------------------------------------------------------
; Macro        gennet
; -----------------------------------------------------------------------
; Description  generates interactively a feedforward network
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, Janet Grassmann,  951231; Sigbert Klinke, 961121
; -----------------------------------------------------------------------
  do               
    l = readvalue ("Number of hidden layers:", 0)               
  until (l.>=0)               
  v = x3matrix(l+2, 2, 1~2)               
  v[1,] = ui~0               
  netid = string ("FFN    : %.0f-", ui)         
  i = 0               
  while (i.<l)  
    i = i+1
    str = string ("Units in hidden layer %.f:", i)               
    str = str|string ("Activation function in hidden layer %.f:", i)               
    vi  = readvalue(str, 1|2);
    v[i+1,1] = vi'
    netid = netid + string("%0.f-", vi[1,1])
  endo               
  v[l+2,1] = uo               
  netid = netid + string("%0.f", uo)
  str = string ("Activation function in output layer:", i)               
  v[l+2,2] = readvalue(str, 2)               
  {w, u, m}=nnlayer(v, vn)               
  w = w~weinit(w, ran)               
  l = nninit(w, u)               
  w = index(w, l)              
endp               
