proc (xplcolor, xplsymbol, xplsize) = getxgobiinfo (pointtype)
  size = floor (pointtype / 1000)
  remainder = pointtype % 1000
  symbol = floor (remainder / 100)
  remainder = remainder % 100
  erase = floor (remainder / 11)
  color = remainder % 11
  
  xgcolor = getglobal ("XGobiColormap")
  
  xplcolor = color ~ color ~ color
  xplsymbol = symbol
  xplsize = 2 + 3 * size
  
  i = 1
  
  do
    xplcolor[i] = xgcolor[color[i] + 1]
    
    switch
      case (symbol[i] == 0) xplsymbol[i] = 11  break;
      case (symbol[i] == 1) xplsymbol[i] = 5  break;
      case (symbol[i] == 2) xplsymbol[i] = 2  break;
      case (symbol[i] == 3) xplsymbol[i] = 7  break;
      case (symbol[i] == 4) xplsymbol[i] = 3  break;
      case (symbol[i] == 5) xplsymbol[i] = 8  break;
      case (symbol[i] == 6) xplsymbol[i] = 1  break;
    endsw
    
    if (erase[i] == 1)
      xplsymbol[i] = 0
    endif
    
    i = i+1
  until (i > dim(pointtype))
  
endp

