proc(out)=givenrot(in)
; -----------------------------------------------------------------------
; Library      pp
; -----------------------------------------------------------------------
; See_also     plotgt orthonormal
; -----------------------------------------------------------------------
; Macro        givenrot
; -----------------------------------------------------------------------
; Description  Decomposes an orthonormal matrix into a set of rotations
;              by Givens rotation
; -----------------------------------------------------------------------
; Usage        out = givenrot (in)
; Input
;   Parameter  in
;   Definition p x p matrix
; Outout
;   Parameter  al
;   Definition p x (p-1)/2 vector
; -----------------------------------------------------------------------
; Example      ; loads the library pp
;              library ("pp")
;              ; generate some vectors
;              x = normal(6,4)
;              ; orthonormalize x 
;              o = orthonormal(x)
;              ; check it
;              o'*o
; -----------------------------------------------------------------------
; Result       gives the appropriate (4x4) identity matrix 
; -----------------------------------------------------------------------
; Link         ../tutorials/grstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 971110
; -----------------------------------------------------------------------
    p   = rows(in)
    out = NaN.*matrix(p*(p-1)/2)
    i = 0
    k = 0
    while (i<p)
      i = i+1
      j = i
      while (j<p)
        j  = j+1
        k  = k+1
        out[k] = atan(in[j,i]/in[i,i])
        r  = (1:p)'==(1:p)
        r[i,i] = cos(out[k])
        r[i,j] = sin(out[k])
        r[j,i] = -sin(out[k])
        r[j,j] = cos(out[k])
        in     = r*in
      endo
    endo
    xdiag(in)
endp