proc () = glmmain ()
; -----------------------------------------------------------------
; Library        glm
; -----------------------------------------------------------------
;  See_also      putglobal
; -----------------------------------------------------------------
;   Macro        glmmain
; -----------------------------------------------------------------
;   Description  sets defaults for library glm.
; -----------------------------------------------------------------
;   Link   ../tutorials/glmstart.html Tutorial: GLM in XploRe 
; -----------------------------------------------------------------
;   Usage        library("glm")
;   Input
;     Parameter  
;     Definition 
;   Output
;     Parameter  
;     Definition 
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; -----------------------------------------------------------------
;  if (exist("xploremain")!=10)
    library("xplore")
;  endif
  func("summarize")
;
; classify models
;
  binomial = "bilo"|"bipro"|"bicll"
  poisson  = "polog"|"popow"
  gaussian = "noid"|"nopow"
  gamma    = "gacl"|"gapow"
  igaussian= "igcl"|"igpow"
  nbinomial= "nbcl"|"nbpow"
;
  twoparfam = gaussian|gamma|igaussian
;
  all=binomial|poisson|gaussian|gamma|igaussian|nbinomial
;
  direct   = "noid"
  canonical= "bilo"|"noid"|"polog"|"gacl"|"igcl"|"nbcl"
  power    = "nopow"|"popow"|"gapow"|"igpow"|"nbpow"
;
; make them globally available
;
  glmmodels=list(binomial,poisson,gaussian,gamma,igaussian,nbinomial)
  append(glmmodels,twoparfam)
  append(glmmodels,all)
  append(glmmodels,canonical)
  append(glmmodels,direct)
  append(glmmodels,power)
;
  putglobal("glmmodels")
endp



