proc(y)=glmmultshape(x,m,format)
; ----------------------------------------------------------------------------
; Library       glm
; ----------------------------------------------------------------------------
;  See_also     glmmultlo
; ----------------------------------------------------------------------------
;   Macro       glmmultshape
; ----------------------------------------------------------------------------
;   Description  reshapes data from panel format to matrix format and
;                vice versa. The matrix format is needed for glmmultlo.
; ----------------------------------------------------------------------------
;   Link  ../tutorials/glmstart.html Tutorial: GLM in XploRe 
; ----------------------------------------------------------------------------
;   Usage        xnew = glmmultshape(x,m,format)
;   Input
;     Parameter   x  
;     Definition        n x r matrix, the predictor variables. x can
;                       be either in matrix format, then r=m*q, i.e.
;                       x consists of q nxm matrices. If x is in panel
;                       format, n=m*k.
;     Parameter   m  
;     Definition        number of alternatives.
;     Parameter   format
;     Definition        either "panel" or "matrix", the format that
;                       the output should have.
;   Output
;     Parameter   xnew
;     Definition        reshaped x matrix.
; ----------------------------------------------------------------------------
;   Example   library("glm") 
;             x=(1~2)|(3~4)|(5~6)|(1~2)|(3~4)|(5~6)
;             x
;             x=glmmultshape(x,3,"matrix")
;             x
;             x=glmmultshape(x,3,"panel")
;             x
; ----------------------------------------------------------------------------
;   Result    Contents of x
;             [1,]        1        2 
;             [2,]        3        4 
;             [3,]        5        6 
;             [4,]        1        2 
;             [5,]        3        4 
;             [6,]        5        6 
;             Contents of x
;             [1,]        1        3        5        2        4        6 
;             [2,]        1        3        5        2        4        6 
;             Contents of x
;             [1,]        1        2 
;             [2,]        3        4 
;             [3,]        5        6 
;             [4,]        1        2 
;             [5,]        3        4 
;             [6,]        5        6 
; ----------------------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/18
; ----------------------------------------------------------------------------
;
  n=rows(x)
  p=cols(x)
  q=p/m
;
  if (format=="panel")
    y=0.*matrix(n*m,p/m)
    j=0
    while (j<q)
      j=j+1
      tmp=x[,(j-1)*m+1:j*m]
      y[,j]=vec(tmp')
    endo
  else
    y=0.*matrix(n/m,p*m)
    j=0
    while (j<p)
      j=j+1
      tmp=reshape(x[,j],m|(n/m))'
      y[,(j-1)*m+1:j*m]=tmp
    endo
  endif
endp


