proc (r) = gp1me (alpha, t)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      empme gpme
; -----------------------------------------------------------------
;   Macro         gp1me
; -----------------------------------------------------------------
;   Description   gp1me evaluates the mean excess function of the
;                 Pareto (GP1) distribution with shape parameter alpha for
;		              all elements of a vector.
; -----------------------------------------------------------------
;   Usage         r = gp1me(alpha, t)
;   Input
;     Parameter   alpha
;     Definition      scalar, shape parameter
;     Parameter   t
;     Definition      vector
;   Output
;     Parameter   r
;     Definition      vector
; -----------------------------------------------------------------
;   Example   library("finance")
;	            gp1me(1.5,3)
; -----------------------------------------------------------------
;   Result    Contents of r
;             [1,]        6 
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  if (alpha <= 1)
    error (alpha <= 1, "GP1 mean excess function does not exist")
  endif
  r = t / (alpha - 1)
endp
