proc(notok)=gplmtest()
; -----------------------------------------------------------------
; Library       gplm
; -----------------------------------------------------------------
;  See_also     gplmest gplmopt 
; -----------------------------------------------------------------
;   Macro       gplmtest
; -----------------------------------------------------------------
;   Description  gplmtest verifies the GPLM macros.                 
; -----------------------------------------------------------------
;   Link  ../tutorials/gplmstart.html Tutorial: GPLM in XploRe 
; ----------------------------------------------------------------------------
;   Usage        notok = gplmtest()
;   Input
;     Parameter   
;     Definition        none     
;   Output
;     Parameter   notok
;     Definition        '0' if test was o.k., '1' otherwise     
; -----------------------------------------------------------------
;   Example   library("gplm") 
;             gplmtest()
; -----------------------------------------------------------------
;   Result    Content of object notok
;             [1,]     0 
; -----------------------------------------------------------------
;   Author    Marlene Mueller, 2000/05/10
; -----------------------------------------------------------------
    n=100
    b=1|2
    p=rows(b)
    x=2.*uniform(n,p)-1
    t=2.*uniform(n,2)-1
    m=sum(cos(pi.*t),2) 
    tg=grid(-1|-1,0.2|0.2,11|11)
    y=x*b+m + normal(n)./4
;
    opt=gplmopt("tg",tg,"shf",1)
    sf=gplmest("noid",x,t,y,0.7,opt)
    pf=gplmbootstraptest("noid",x,t,y,0.7,1,opt)
;   
    b~sf.b~pf.b
    crit=sum(abs(pf.b-sf.b))./sum(abs(b))
    notok=(crit>0.2)
    notok
;
    randomize(1)
    n=100 
    b=1|2 
    p=rows(b) 
    x=2.*uniform(n,p)-1 
    t=sort(2.*uniform(n)-1,1) 
    m=cos(pi.*t) 
    y=( 1./(1+exp(-x*b-m)).>uniform(n) ) 
    ;========================== 
    ;  semiparametric fit  
    ;========================== 
    h=0.6
    opt=gplmopt("shf",1,"fscor",1) 
    sf=gplmest("bilo",x,t,y,h,opt)
;
    crit=sum(abs(b-sf.b))./sum(abs(b))
    notok=notok || (crit>0.2)
;
   "'gplmtest' finished!"
endp


