proc (sigma) = gpsigmaest (gamma, y)
; -----------------------------------------------------------------
;   Library       finance
; -----------------------------------------------------------------
;   See_also      dpgp pickandsgp momentgp
; -----------------------------------------------------------------
;   Macro         gpsigmaest
; -----------------------------------------------------------------
;   Description   estimator for scale parameter within GP models
; -----------------------------------------------------------------
;   Usage         sigma = gpsigmaest (gamma, y)
;   Input
;     Parameter   gamma
;     Definition      scalar, shape parameter
;     Parameter   y
;     Definition      vector, exceedances above threshold
;   Output        
;     Parameter   sigma
;     Definition      scalar, estimated scale parameter
; -----------------------------------------------------------------
;   Notes	Used internally by GP estimators
; -----------------------------------------------------------------
;   Author    Michael Thomas  990503
; -----------------------------------------------------------------
  x = qfx ("gp", (1:rows(y)) / (rows(y) + 1), gamma)
  n = floor (2 / 3 * rows (x))
  if (n < 2) 
    n = 2
  endif
  r = linreg (x[1:n], y[1:n], "notext")
  sigma = r.beta [2]
endp
