proc(axes) = graxes3d(gs,text)
; -----------------------------------------------------------------
;  Library      graphic
; -----------------------------------------------------------------
;  See_also     grsurface, grcube, axesoff
; -----------------------------------------------------------------
;  Macro        graxes3d
; -----------------------------------------------------------------
;  Usage	axes=graxes3d(x,description)
;  Input
;    Parameter  x
;    Definition     	n x 3 matrix
;    Parameter  description
;    Definition  	1 x 3 vector containing the description
;			      of the axes 
;
;  Output
;    Parameter  axes
;    Definition graphical object containing the axes
; -----------------------------------------------------------------
;  Example	library("graphic")
;		m  = matrix(3)* 5
;		form = "%.2f" | "%.2f" | "%.3f"
;		x  = grid (#(-3,-3), #(0.12,0.12), #(31,31)) 
;		f  = exp(-0.5.*(x[,1]^2+x[,2]^2))./(2.*pi) 
;		gc = grcube(x~f,m,form)
;		gs = grsurface(x~f) 
;		axes=graxes3d(x~f,"x-axis"|"y-axis"|"z-axis") 
;		di = createdisplay(1,1)
;		axesoff()  
; 		show(di,1,1,gs,gc.box,gc.x,gc.y,gc.z,gc.c,axes)       
; -----------------------------------------------------------------
;   Description Generates a 3-D axes with descriptions.
; -----------------------------------------------------------------
;   Keywords    graphic primitives
; -----------------------------------------------------------------------
;   Author      zh 2000-05-23
; -----------------------------------------------------------------
  axes= grid((min(gs)'+max(gs)')/2,(max(gs)'-min(gs)')/4,2|2|2)
  text=(""|text[1]|text[2]|""|text[3]|""|""|"")
  setmaskt(axes,text,0,9,10)
  setmaskp(axes,0,0,0)
  setmaskl(axes,(1~2)|(1~3)|(1~5),0,1,1)
endp