proc(grcpdata)=grcirclesector(radius,alpha1,alpha2)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grpie
; -----------------------------------------------------------------------
; Macro        grcirclesector
; -----------------------------------------------------------------------
; Description  Generates a sector of a circle.
; -----------------------------------------------------------------------
; Usage        mysector = grcirclesector(radius,alpha1,alpha2)
; Input
;   Parameter  radius 
;   Definition scalar     radius of circle
;   Parameter  alpha1,alpha2
;   Definition scalars    angles enclosing the sector
; Output                                                                                                                            
;   Parameter  mysector
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              r = 50
;              a1 = 1
;              a2 = 3.14
;              mysector = grcirclesector (r,a1,a2)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, mysector)
; -----------------------------------------------------------------------
; Result       shows a sector of a circle
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, grcircle, grcirclesector
; -----------------------------------------------------------------------
; Author       Rodrigo Witzel, 981111
; -----------------------------------------------------------------------
if ((radius>0) && (alpha1<alpha2))
  grcpdata=(0~0)
  grcpdata=grcpdata|((radius*sin(alpha1))~(radius*cos(alpha1)))
  alpha=alpha1
  i=1
  while (alpha1+(i/144)*(2*pi)<alpha2)
    alpha=alpha1+(i/144)*(2*pi)
    grcpdata=grcpdata|((radius*sin(alpha))~(radius*cos(alpha)))
    i=i+1
  endo
  grcpdata=grcpdata|((radius*sin(alpha2))~(radius*cos(alpha2)))
  grcpdata=grcpdata|(0~0)
  setmaskl(grcpdata,(1:(i+3))',0,1,1)
  setmaskp(grcpdata,1,0,1)
else
  warning(((radius<=0) || (alpha1>=alpha2)),"grcake: -Error- radius<=0 or alpha1>=alpha2")
  grcpdata=(0~0)
endif
endp

