proc(gs)=grcontour3(x, c, col) 
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grlinreg2 grsurface grcontour2 grsunflower contour3
; -----------------------------------------------------------------------
; Macro        grcontour3
; -----------------------------------------------------------------------
; Description  generates a contour plot from a 4-dimensional dataset x.
; -----------------------------------------------------------------------
; Usage        gs = grcontour3 (x, c, {, col})
; Input
;   Parameter  x
;   Definition n x 4 matrix 
;   Parameter  c
;   Definition m x 1 vector 
;   Parameter  col
;   Definition m x 1 color
; Output
;   Parameter  gs
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              x  = grid (-#(3,3,3), #(0.5,0.5,0.5), #(13,13,13))
;              f  = exp(-0.5.*sum(x^2,2))./(2.*pi)^1.5
;              c  = #(0.25, 0.5, 0.75).*max(f)
;              gs = grcontour3 (x~f, c)
;              d  = createdisplay (1,1)
;              show (d, 1, 1, gs)
; -----------------------------------------------------------------------
; Result       shows a contour plot 
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, contour plot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 961022
; -----------------------------------------------------------------------
  error (cols(x).<>4, "grcontour3 : cols(x)<>4")
  if (exist("col").<>1)
    grc = getglobal ("grc")  
    col = grc.col.black.*matrix(rows(c))
  endif
  error (rows(c).<>rows(col), "grcontour3 : rows(c)<>rows(col)")
; find x coordinates
  xs = sort(x, #(1,2,3,4))
  i  = 0
  while (i.<rows(c))
    i = i+1
    if (i.=1)
      {lt, pt} = contour3 (xs, c[i])
      lc = col[i].*matrix(rows(lt))
    else
      {lti, pti} = contour3 (xs, c[i])
      lci = col[i].*matrix(rows(lti))
      lc  = lc|lci
      lt  = lt|(lti+rows(pt))
      pt  = pt|pti
    endif
  endo
  gs = pt
  setmaskp (gs, 0, 0, 0)
  setmaskl (gs, lt, lc, 1, 2)
endp
