proc(box,x,y,z,c) = grcube(gs,m,form)
; -----------------------------------------------------------------
; Library        graphic
; -----------------------------------------------------------------
;  See_also      grsurface
; -----------------------------------------------------------------
;   Macro        grcube
; -----------------------------------------------------------------
;   Description  Generates a 3-D cube with labels at the axes
;                surrounding a 3-dimensional dataset.
; -----------------------------------------------------------------
;   Usage        gc = grcube(x{,m{,form}})    
;   Input
;     Parameter   x  
;     Definition      n x 3 matrix    
;     Parameter   m 
;     Definition      3 x 1 vector or scalar, numbers of labels for 
;                                             each of the axes
;     Parameter   form 
;     Definition      3 x 1 string vector or 1 string, the formatstring(s)
;                                                 for the axes x, y and z 
;   Output                                                           
;     Parameter   gc
;     Definition      composed graphical object:  
;                     gc.box : box around the data  
;                     gc.x   : label for the x-axes  
;                     gc.y   : label for the y-axes  
;                     gc.z   : label for the z-axes  
;                     gc.c   : label for the corners  
; -----------------------------------------------------------------
;   Example   library("graphic")
;             m  = matrix(3)* 5
;             form = "%.2f" | "%.2f" | "%.3f"
;             x  = grid (#(-3,-3), #(0.12,0.12), #(31,31)) 
;             f  = exp(-0.5.*(x[,1]^2+x[,2]^2))./(2.*pi) 
;             gc = grcube(x~f,m,form)
;             gs = grsurface(x~f) 
;             di = createdisplay(1,1)
;             show(di,1,1,gs,gc.box,gc.x,gc.y,gc.z,gc.c)       
; -----------------------------------------------------------------
;   Result    shows a surface surrounded by a cube with labels
; -----------------------------------------------------------------
; Keywords     graphic primitives
; -----------------------------------------------------------------------
;   Author    Schmelzer,Sperlich 970517
; -----------------------------------------------------------------
    if (exist(m))
       if (rows(m)<3)
         m = m[1]*matrix(3)
       endif  
       m = m-1
    else
       m  = matrix(3)* 4
    endif
    if (exist(form))
       if (rows(form)<3)
          formx= form[1]
          formy= form[1]
          formz= form[1]
       else
          formx= form[1]
          formy= form[2]
          formz= form[3]
       endif
    else
       formx= "%.1f"
       formy= "%.1f"
       formz= "%.1f"
    endif
      box= grid(min(gs)',max(gs)'-min(gs)',2|2|2)
      mi = min(gs)
      ma = max(gs)
      x = aseq(mi[,1],m[1],(ma[,1]-mi[,1])/m[1])
      x = x[2:m[1]]~(mi[,2:3].*matrix((m[1]-1)))
      xstr= string(formx, x[,1])
      setmaskp(x, 0, 0, 0)
      setmaskt(x, xstr, 0, 6, 10)
      y = aseq(mi[,2],m[2],(ma[,2]-mi[,2])/m[2])
      y = (mi[,1].*matrix((m[2]-1)))~y[2:m[2]]~(mi[,3].*matrix((m[2]-1)))
      ystr= string(formy, y[,2])
      setmaskp(y, 0, 0, 0)
      setmaskt(y, ystr, 0, 9, 10)
      z = aseq(mi[,3],m[3],(ma[,3]-mi[,3])/m[3])
      z = (mi[,1:2].*matrix((m[3]-1)))~z[2:m[3]]
      zstr= string(formz, z[,3])
      setmaskp(z, 0, 0, 0)
      setmaskt(z, zstr, 0, 9, 10)
      c = box
      eckstr = "("+formx+","+formy+","+formz+")"
      coord = string(eckstr, c[,1], c[,2], c[,3])
      coord[4]  = " "
      coord[6:8]= " "
      setmaskt(c, coord, 0, 6, 10)
      setmaskp(c,0,0,0)
      setmaskp(box,0,0,0)
      cube=(1~2~4~3~1)|(5~6~8~7~5)|(1~5~0~2~6)|(3~7~0~4~8)
      setmaskl(box,cube,0,1,1) 
endp

