proc(grout)=grscale(grin,  shf)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grrot
; -----------------------------------------------------------------------
; Macro        grscale
; -----------------------------------------------------------------------
; Description  scales a graphical object
; -----------------------------------------------------------------------
; Usage        grout = grscale (grin, shf)
; Input
;   Parameter  grin
;   Definition composed graphical object
;   Parameter  shf
;   Definition 1 x 2 vector
; Output
;   Parameter  grout
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Example      library ("graphic")
;              t   = (normal(25)-8)|(normal(25)+8)|normal(100)|(normal(10)+25)
;              bp1 = grdot (t)
;              bp2 = grscale (bp1, #(1, 2))
;              d   = createdisplay (1,1)
;              show (d, 1, 1, bp1, bp2)
; -----------------------------------------------------------------------
; Result       shows a the same dotplot twice, one scaled by 2 in y-direction
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960925
; -----------------------------------------------------------------------
  grout = grin
  grout[,1] = grout[,1] * shf[1]
  grout[,2] = grout[,2] * shf[2]
endp