proc(dp)=grstar(x, col, option, minmax)
; -----------------------------------------------------------------------
; Library      graphic
; -----------------------------------------------------------------------
; See_also     grbar grbox grhist
; -----------------------------------------------------------------------
; Macro        grstar
; -----------------------------------------------------------------------
; Description  Generates a star diagram. 
; -----------------------------------------------------------------------
; Usage        bp = grstar (x {, col {, option {, minmax}}})
; Input
;   Parameter  x 
;   Definition n x 1      vector
;   Parameter  col
;   Definition color
;   Parameter  option
;   Definition scalar     
; Output
;   Parameter  bp
;   Definition composed graphical object
; -----------------------------------------------------------------------
; Notes        minmax gives for each variables
;              the minimum and maximum of the plot area.
;              option[1,1] fixes the number of stars in y direction.
;              option[2,1] determines the line style.
; -----------------------------------------------------------------------
; Example      ; loads the library graphic
;              library ("graphic")
;              ; reads the swiss banknote data (200x6)
;              x = read("bank2")
;              ; computes a star diagram of x based on the principal
;              ; on the principal components
;              bp = grstar (x, 0, grc.prep.pcacov)
;              ; creates a display
;              t  = createdisplay(1,1)
;              ; shows the star diagram
;              show (t, 1, 1, bp)
; -----------------------------------------------------------------------
; Result       shows a star diagram of the principal components of the
;              swiss banknote data
; -----------------------------------------------------------------------
; Link         ../tutorials/graphicstart.html Introduction to the graphic library
; -----------------------------------------------------------------------
; Keywords     graphic primitives, star diagrem plot
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 970202
; -----------------------------------------------------------------------
   error(cols(x).<3, "grstar : cols(x)<3")
   grc = getglobal ("grc")  
   if (exist("col").<>1)
     col = grc.col.black
   endif
   n   = rows(x)
   if (rows(col)==1)
     col = col.*matrix(n, cols(col))
   endif
   if (exist("option").<>1)
     option = ceil(sqrt(n))|1
   endif
   if (rows(option)<2)
     option = option|1
   endif
   if (exist("minmax")<>1)
     minmax = min(x)|max(x)
   endif
   if (exist("option").<>1)
     option = ceil(sqrt(n))
   endif
   error (option[1] < 2, "grstar: option<2")
   error (cols(minmax)<>cols(x), "grstar: cols(minmax)<>cols(x)")
   y = (x-minmax[1,])./(minmax[2,]-minmax[1,])
   p = cols(y)
   w = grid(0, 2*pi/p, p)
   pp = (0:n-1)./option[1]
   pp = trans(floor(pp)~floor(option[1]*(1.0e-5+pp-floor(pp))))
   reshape("pp", #(1,2,n))
   r  = y
   reshape ("r", #(p,1,n))
   r  = trans(pp+0.5.*r.*(cos(w)~sin(w)))
   reshape ("r", #(2,n*p))
   dp = trans(r)
   li = grid(1, p, n)+trans((0:(p-1))|0)
   setmaskp (dp, 0, 0, 0)
   setmaskl (dp, li, col, option[2], 1)
endp