proc(r,c,l,d,titl)=gruppenvariable2(data,f,selvar,dcoltype)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     barchart boxplot doista dotplot histgram showd  
; -----------------------------------------------------------------------
; Macro        gruppenvariable2
; -----------------------------------------------------------------------
; Description  creates according the selected variables and group variables
;              the appropriate parameters d, c, r and title to build the 
;              displays in showd for barcharts, boxplots, dotplots
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter 980616
;------------------------------------------------------------------------
  rn=rows(data.x)
  if(max(selvar)==1) 
    ;from"choosevariable",if variable has appropriate type and is undeleted                
    datah=paf(data.x',selvar)'
    datah=paf(datah, data.rowcase&&data.randcase&&data.rowmissing)
    ;matrix with chosen variables 
    colname= paf(data.colname,selvar) 
    sel1=choosegroup(data,selvar,dcoltype)
    ;dcoltype contains only discrete variables
    if(sum(sel1))
      colnamegr=paf(data.colname,sel1)
    endif
    r = 0
    c = 0
    d = 0
    l = list(0)
    titl=" "
    k=0
    di    = 0
    while(k.<cols(datah)) ;loop over variables
      k=k+1
      datah2=datah[,k] ;univariate analyses
      if (sum(sel1))   ;group variable exists?
        sel2 = paf((1:rows(sel1)), sel1) ;extract group variable
        i = 0
        ;selected variables with different group variable
        ;are shown according the different values, q is used to 
        ;to make sure that displays for next variables starts in the
        ;right window
        while (i<rows(sel2)) ;loop over group variables
          i   = i+1
          sel = sel2[i] 
          colh=data.x[,sel] ;colors according values of group variable  
          colh=paf(colh, data.rowcase&&data.randcase&&data.rowmissing)
          ;extract cases according values of group variable (25 possible)       
          {g,gind}=groupcol(colh, rn)
          color = 0
          w     = 0
          mg    = max(gind)
          switch
          case (mg<6)
            maxcolor = 6
            break
          case (mg<11)
            maxcolor = floor(mg/2+1.75)
            break
          case (mg==11)
            maxcolor = #(5,5,4)
            break 
          case (mg==12)
            maxcolor = #(5,5,5)
            break 
          case (mg==13)
            maxcolor = #(6,5,5)
            break 
          case (mg==14)
            maxcolor = #(6,6,5)
            break 
          case (mg==15)
            maxcolor = #(6,6,6)
            break 
          case (mg==16)
            maxcolor = #(5,5,5,5)
            break 
          case (mg==17)
            maxcolor = #(6,5,5,5)
            break 
          case (mg==18)
            maxcolor = #(6,6,5,5)
            break 
          case (mg==19)
            maxcolor = #(6,6,6,5)
            break 
          case (mg==20)
            maxcolor = #(6,6,6,6)
            break 
          case (mg==21)
            maxcolor = #(6,5,5,5,5)
            break 
          case (mg==22)
            maxcolor = #(6,6,5,5,5)
            break 
          case (mg==23)
            maxcolor = #(6,6,6,5,5)
            break 
          case (mg==24)
            maxcolor = #(6,6,6,6,5)
            break 
          case (mg==25)
            maxcolor = #(6,6,6,6,6)
            break 
          default
            maxcolor = 6
          endsw
          while (w<max(gind))
            if (color==0)
            ;first window all cases
              di = di+1
              q = 1
              r = r|q
              q = q+1
              d = d|di
              obj=_f(datah2,0,rn)      ;first plot all cases        
              object=min(obj)|max(obj) ;centralize data with invisible object
              setmaskp(object,0,0,0)   
              append(l, obj)           
              titl=titl|colname[k]
              c = c|k
            else
              w=w+1 
              h=(gind==w) 
              xh=paf(datah2,h)
              ;extract cases according values of group variable
              obj=_f(xh, color,rn)
              if(exist("obj")==9)
              ;if obj not 9, then error 
                r = r|q|q ;if obj =9 (list) put obj and object in the same window 
                q = q+1   
                c = c|k|k
                d = d|di|di        
                append(l, object)   
                append(l, obj)
                ti =(colnamegr[sel]+string("==%.0f (n=%.0f)",g[w], rows(xh)))                
                titl=titl|ti|ti
              else
                r = r|q ;if error message put message in separate window
                c = c|k   
                d = d|di
                q = q+1 
                append(l, obj)   
                titl=titl|"Fehler"
              endif
            endif
            color = color+1
            if (color==maxcolor[di]) 
              color = 0
            endif 
           endo
         endo
      else
;alll cases (no group variable)
        append(l,_f(datah2,0,rn))
        r = r|1
        c = c|k  
        d = d|1
        titl=titl|colname[k]
      endif
    endo
  endif
endp