proc (uselret, bn1, bn2) = hardthres (usel, b1, b2, x)
; -----------------------------------------------------------------------
; Library      twave 
; -----------------------------------------------------------------------
; See_also     hardauto softauto softthres
; -----------------------------------------------------------------------
; Link         ../tutorials/wavestart.html Wavelet tutorial
; -----------------------------------------------------------------------
; Macro        hardthres
; -----------------------------------------------------------------------
; Description  Hardthresholds the mother wavelet coefficients b1 and b2 
;              interactively. The user is a threshold offered by 
;              sqrt(2 sigma n). To compute the threshold value only b1 
;              and x is used.
; -----------------------------------------------------------------------
; Usage        {ur, bn1, bn2} = hardthres (usel, b1, b2, x)
; Input
;   Parameter  usel 
;   Definition vector   commands
;   Parameter  b1
;   Definition n x 3 array     of mother wavelet coefficient
;   Parameter  b2
;   Definition n x 3 array     of mother wavelet coefficient
;   Parameter  x
;   Definition m x 1 array     of data
; Output
;   Parameter  ur
;   Definition vector   commands
;   Parameter  bn1
;   Definition n x 3 array     of thresholded mother wavelet coefficient
;   Parameter  bn2
;   Definition n x 3 array     of thresholded mother wavelet coefficient
; -----------------------------------------------------------------------
; Author       Sigbert Klinke, 960912
; -----------------------------------------------------------------------
  ru = rows(usel)
  if (ru.>1)
    ht = usel[2]
    if (ru.>2)
      usel = usel[1]|usel[3:ru]
    else
      usel = usel[1]
    endif
  else
    n   = rows(x)
    ba  = max(b1[,1])
    bt  = paf(b1[,3], b1[,1].=ba)
    vn  = 2.*sum(bt^2)/n
    mb  = sqrt(2.*vn.*log(rows(b2)))
    ht  = readvalue("Hard Threshold",  mb)
  endif
  ht  = abs(ht)
  bn1 = b1[,1:2]~(b1[,3].*(abs(b1[,3]).>abs(ht)))
  bn2 = b2[,1:2]~(b2[,3].*(abs(b2[,3]).>abs(ht)))
  uselret = usel
endp
