proc(h)=hgenrr(a,b,di,ord,rang)
; -----------------------------------------------------------------
;   Library      multi
; -----------------------------------------------------------------
;   See_also     domulti 
; -----------------------------------------------------------------
;   Macro        hgenrr
; -----------------------------------------------------------------
;   Description  Generation of H for the Reduced Rank VAR Model
; -----------------------------------------------------------------
;   Usage        h=hgenrr(a,b,di,ord,rang)  
;   Input
;     Parameter   a  
;     Definition      Matrix A (di x rk)   
;     Parameter   b 
;     Definition      Matrix B (rk x di)  
;     Parameter   di
;     Definition      integer, dimension of time series
;     Parameter   ord
;     Definition      integer, order of VAR model
;     Parameter   rang
;     Definition      integer, rank of VAR model 
;   Output                                                           
;     Parameter     h    
;     Definition    loading matrix
; -----------------------------------------------------------------
;   Example   library("multi")
;             hgenrr(1|2,1~3,2,1,1)
; -----------------------------------------------------------------
;   Result    Contents of h
;             [1,]        1        0        1        0 
;             [2,]        0        1        2        0 
;             [3,]        3        0        0        1 
;             [4,]        0        3        0        2 
; -----------------------------------------------------------------
;   Author    TP A2, CH 980408
; -----------------------------------------------------------------
x=reshape(aseq(1,rang*di*ord,1),#(di*ord,rang))'
y=ones(1,rang*di*ord)
k=kron(eye(di*ord),a)
g=k*(kron(vec(x),y).==aseq(1,rang*di*ord,1)')
h=kron(b',eye(di))~g
endp;
