proc (y)=highepa(x, q)
; -----------------------------------------------------------------
; Library       kernel
; -----------------------------------------------------------------
;  See_also     highgau
; -----------------------------------------------------------------
;   Macro       highepa
; -----------------------------------------------------------------
;   Description  highepa computes the multivariate higher order 
;                kernel derived from the epanechnikov kernel 
; -----------------------------------------------------------------
;   Usage        y = highepa(x, {q})
;   Input
;     Parameter  x  
;     Definition n x p matrix
;     Parameter  {q}  
;     Definition order of the kernel, default is 2, can be 4, 6, 8
;   Output
;     Parameter  y  
;     Definition  n x 1 matrix
; -----------------------------------------------------------------
;   Example   library("kernel") 
;             x = aseq(-1, 41, 0.05) 
;             y = highepa(x,6) 
;             t=createdisplay(1,1)                                      
;             show(t,1,1,x~y)                                    
; -----------------------------------------------------------------
;   Result    The kernel is pictured  
; -----------------------------------------------------------------
;   Author    Lijian Yang, 970719  
; -----------------------------------------------------------------
if (exist(q)==0)    
    q=2                                      
endif   
if (q==2)
   y=prod(0.75.*(1-x.^2).*(abs(x).<1),2) 
endif
if (q==4)
   y=prod(0.46875.*(1-x.^2).*(3-7.*x.^2).*(abs(x).<1),2)
endif
if (q==6)
   y=prod(0.41015625.*(1-x.^2).*(5-30.*x.^2+33.*x.^4).*(abs(x).<1),2)
endif
if (q==8)   y=prod(0.076904296875.*(1-x.^2).*(35-385.*x.^2+1001.*x.^4-715.*x.^6).*(abs(x).<1),2)
endif
endp
