proc(a)=hill(x,m)
; ----------------------------------------------------------------------
; Library 	  finance
; ----------------------------------------------------------------------
;  See_also	  taills
; ----------------------------------------------------------------------
;   Macro	  hill
; ----------------------------------------------------------------------
;   Description   Estimates the tail index of fat-tailed distributions
; ----------------------------------------------------------------------
;   Usage         a = hill(x,m)
;   Input
;     Parameter   x
;     Definition  (n*p) matrix
;     Parameter   m
;     Definition  scalar
;   Output
;     Parameter   a
;     Definition  p-vector giving for each column of x the inverse of the
;                 Hill estimate, i.e., the tail index 
; ----------------------------------------------------------------------
;   Example       library("finance")
;                 randomize(0)
;                 x=normal(1000,2)
;                 hill(x,10)
; ---------------------------------------------------------------------
; Result          Contents of a

;                 [1,]   5.9057 
;                 [2,]   5.9285 
; ---------------------------------------------------------------------
; Keywords      	tail index
; ---------------------------------------------------------------------
; Reference       Hill, B.M. (1975): A simple general approach to inference
;                 about the tail of a distribution, Annals of Statistics
;                 35:1163-1173.
; ----------------------------------------------------------------------
;   Author        Christian Hafner, 981110
; ----------------------------------------------------------------------
n=rows(x)
k=cols(x)
a=matrix(k,1)
x=x-mean(x)
error(min(sum(x.>0))<m,"Row dimension too small !")
i=1
while(i<=k)
  x=sort(x,(-i))
  hill=mean(log(x[1:(m-1),i]))-log(x[m,i])
  a[i,]=1/hill
  i=i+1
endo
endp
