proc(obj)=histogramrech(x, w,n)
; -----------------------------------------------------------------------
; Library      ista
; -----------------------------------------------------------------------
; See_also     histgram doista grhist gruppenvariable2  istagraphic showd 
; -----------------------------------------------------------------------
; Macro        histgrammtrech
; -----------------------------------------------------------------------
; Description  computes the histogram for selected variables 
;------------------------------------------------------------------------
; Notes        to be used only in context with "doista"
; -----------------------------------------------------------------------
; Keywords     
;------------------------------------------------------------------------
; Author       Kerstin Zanter   980616
;------------------------------------------------------------------------
  if (w==0)  
    ob=0|sqrt(var(x))./2
    ;sets origin, binwidth for first computation
    vtrs1="select origin"|"select binwidth"
    oribin=readvalue(vtrs1, ob)
    putglobal("oribin")
  else
    oribin = getglobal("oribin")
  endif  
  obj = grhist(x,oribin[2],oribin[1],w)
  ;computation of the composed object
  if((rows(x).>1)&&(var(x)>0)) ;two datapoints are needed and no misssings
    obj=grbox(x,w)              ;computes the composed object
    obj = grhist(x,oribin[2],oribin[1],w)
    ;computation of the composed object
    obj = grscale(obj,#(1,rows(x)/n)) ;object to scale the data     
  else
      obj="One realization only"|"or missing(s):"|"no histogram possible"
  endif
endp 

