proc(dat)=influence()
;
; -----------------------------------------------------------------
; Library  	  finance
; -----------------------------------------------------------------
;  See_also       optstart
; -----------------------------------------------------------------
;   Macro         influence
; -----------------------------------------------------------------
;   Description   displays the influence of price determining
;                 parameters on options. It is
;                 using the Black and Scholes formula.
; -----------------------------------------------------------------
;   Usage         dat = influence()
;   Input         
;   Output        
;     Parameter   dat  
;     Definition    n x m matrix, grid of running inputs and the
;                                 values of the corresponding options   
; -----------------------------------------------------------------
;   Example   library("finance")
;             influence()
; -----------------------------------------------------------------
;   Result    display, showing the option prices 
; -----------------------------------------------------------------
;   Author    Sperlich, Hesse  970526 
; -----------------------------------------------------------------
;
    ahead = "What Kind of Option do You have?"
valuestrs1 = "Price of underlying asset"|"Exercise price"|"Domestic interest rate per year (%)"|"Volatility per year (%)"|"Time to expiration (years)"|"Cost of carry (%)"
      if (exist("v1")==0)
        vor=230|210|5.0|25.0|0.5|5.0
      endif
      values1=vor
      vor=readvalue(valuestrs1,values1)
;
selhead = "Select influence variables (max.2)"
s1="Price of underlying asset"
s2="Exercise price"
s3="Volatility per year (%)"
s4="Time to expiration (years)"
s5="Domestic interest rate per year (%)"
s6="Cost of carry (%)"
selitem = s1|s2|s3|s4|s5|s6
end = 1
do
              s=vor[1]                 ;stock price
              k=vor[2]                 ;exercise price 
              i=log(0.01*vor[3]+1)     ;rate of interest
              v=0.01*vor[4]            ;volatility
              t=vor[5]
              q=log(0.01*vor[6]+1)
	sel = selectitem (selhead,selitem)
	end = sum (sel).=0
	;
     if ( sum(sel)==1 ) 	
      zeichen="Lower bound for chosen variable:"|"upper bound:"
	if (sel[1])
		values=150|250
		ss=readvalue(zeichen,values)
		s1=ss[1]
		s2=ss[2]
		sw=(s2-s1)/30
		lauf=aseq(s1,31,sw)
		s = lauf
	endif
	if (sel[2])
		values=150|250
		ss=readvalue(zeichen,values)
		k1=ss[1]
		k2=ss[2]
		sw=(k2-k1)/30
		k=aseq(k1,31,sw)
                lauf=k
	endif
	if (sel[3])
		values=10|30
		ss=readvalue(zeichen,values)
		v1=ss[1]
		v2=ss[2]
		sw=(v2-v1)/30
		v=aseq(v1,31,sw)*0.01
		lauf=v
	endif
	if (sel[4])
		values=0.1|1.0
		ss=readvalue(zeichen,values)
		t1=ss[1]
		t2=ss[2]
		sw=(t2-t1)/30
		t=aseq(t1,31,sw)
		lauf=t
	endif
	if (sel[5])
		values=2|10
		ss=readvalue(zeichen,values)
		i1=ss[1]
		i2=ss[2]
		sw=(i2-i1)/30
		i=aseq(i1,31,sw)
		i=log(0.01*i+1) 
		lauf=i
	endif
        if (sel[6])
		values=2|10
		ss=readvalue(zeichen,values)
		q1=ss[1]
		q2=ss[2]
		sw=(q2-q1)/30
		q=aseq(q1,31,sw)
		q=log(0.01*q+1) 
		lauf=q
        endif
      y=(log(s./k)+(i-q-v^2/2).*t)/(v.*sqrt(t))
    what = 0|0
    do 
     callput = "Call"|"Put" 
      what = selectitem (ahead, callput)
      if (what[1])
	opv = s.*exp(-q.*t).*cdfn(y+v.*sqrt(t))-k.*exp(-i.*t).*cdfn(y)
      endif 
      if (what[2])
        opv = k.*exp(-i.*t).*cdfn(-y)-s.*exp(-q.*t).*cdfn(-y-v.*sqrt(t))
      endif
    until (sum(what)==1)
      dat = lauf~opv
      setmaskp(dat,0,0,0)
      setmaskl(dat, (1:rows(dat))', 0,1,2)
      d=createdisplay(1,1)
      show(d,1,1,dat)
     endif
     if ( sum(sel)==2 ) 	
      zeichen1="First variable, lower bound:"|"upper bound:"
      zeichen2="Second variable, lower bound:"|"upper bound:"
       switch
	 case(sel[1]==1)
 	     values=150|250
	     ss=readvalue(zeichen1,values)
	     s1=ss[1]
	     s2=ss[2]
	     sw1=(s2-s1)/30
 	   if (sel[2])
		values=150|250
		ss=readvalue(zeichen2,values)
		k1=ss[1]
		k2=ss[2]
		sw2=(k2-k1)/30
             lauf=grid(#(s1,k1),#(sw1,sw2),#(31,31))
             k=lauf[,2]
 	   endif
	   if (sel[3])
		values=10|30
		ss=readvalue(zeichen2,values)
		v1=ss[1]
		v2=ss[2]
		sw2=(v2-v1)/30
             lauf=grid(#(s1,v1),#(sw1,sw2),#(31,31))
             v=lauf[,2]*0.01
	   endif
	   if (sel[4])
		values=0.1|1.0
		ss=readvalue(zeichen2,values)
		t1=ss[1]
		t2=ss[2]
		sw2=(t2-t1)/30
             lauf=grid(#(s1,t1),#(sw1,sw2),#(31,31))
             t=lauf[,2]
	   endif
	   if (sel[5])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		i1=ss[1]
		i2=ss[2]
		sw2=(i2-i1)/30
             lauf=grid(#(s1,i1),#(sw1,sw2),#(31,31))
             i=lauf[,2]
	   endif
           if (sel[6])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		q1=ss[1]
		q2=ss[2]
		sw2=(q2-q1)/30
             lauf=grid(#(s1,q1),#(sw1,sw2),#(31,31))
             q=lauf[,2]
           endif	
             s=lauf[,1]
	 break
	 case(sel[2]==1)
	     values=150|250
	     ss=readvalue(zeichen1,values)
	     k1=ss[1]
	     k2=ss[2]
    	     sw1=(k2-k1)/30
	   if (sel[3])
		values=10|30
		ss=readvalue(zeichen2,values)
		v1=ss[1]
		v2=ss[2]
		sw2=(v2-v1)/30
             lauf=grid(#(k1,v1),#(sw1,sw2),#(31,31))
             v=lauf[,2]*0.01
	   endif
	   if (sel[4])
		values=0.1|1.0
		ss=readvalue(zeichen2,values)
		t1=ss[1]
		t2=ss[2]
		sw2=(t2-t1)/30
             lauf=grid(#(k1,t1),#(sw1,sw2),#(31,31))
             t=lauf[,2]
	   endif
	   if (sel[5])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		i1=ss[1]
		i2=ss[2]
		sw2=(i2-i1)/30
             lauf=grid(#(k1,i1),#(sw1,sw2),#(31,31))
             i=lauf[,2]
	   endif
           if (sel[6])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		q1=ss[1]
		q2=ss[2]
		sw2=(q2-q1)/30
             lauf=grid(#(k1,q1),#(sw1,sw2),#(31,31))
             q=lauf[,2]
           endif	
             k=lauf[,1]
	 break
	 case(sel[3]==1)
	    values=10|30
	    ss=readvalue(zeichen1,values)
	    v1=ss[1]
   	    v2=ss[2]
	    v=(v1:v2)*0.01
	    sw1=(v2-v1)/30
	   if (sel[4])
		values=0.1|1.0
		ss=readvalue(zeichen2,values)
		t1=ss[1]
		t2=ss[2]
		sw2=(t2-t1)/30
             lauf=grid(#(v1,t1),#(sw1,sw2),#(31,31))
             t=lauf[,2]
	   endif
	   if (sel[5])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		i1=ss[1]
		i2=ss[2]
		sw2=(i2-i1)/30
             lauf=grid(#(v1,i1),#(sw1,sw2),#(31,31))
             i=lauf[,2]
	   endif
           if (sel[6])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		q1=ss[1]
		q2=ss[2]
		sw2=(q2-q1)/30
             lauf=grid(#(v1,q1),#(sw1,sw2),#(31,31))
             q=lauf[,2]
           endif	
             v=lauf[,1]
	 break
	 case(sel[4]==1)
	    values=0.1|1.0
	    ss=readvalue(zeichen1,values)
	    t1=ss[1]
	    t2=ss[2]
	    sw1=(t2-t1)/30
	   if (sel[5])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		i1=ss[1]
		i2=ss[2]
		sw2=(i2-i1)/30
             lauf=grid(#(t1,i1),#(sw1,sw2),#(31,31))
             i=lauf[,2]
	   endif
           if (sel[6])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		q1=ss[1]
		q2=ss[2]
		sw2=(q2-q1)/30
             lauf=grid(#(t1,q1),#(sw1,sw2),#(31,31))
             q=lauf[,2]
           endif	
             t=lauf[,1]
	 break
	 case(sel[5]==1)
	    values=2|10
	    ss=readvalue(zeichen1,values)
  	    ss=log(0.01*ss+1) 
	    i1=ss[1]
	    i2=ss[2]
	    sw1=(i2-i1)/30
           if (sel[6])
		values=2|10
		ss=readvalue(zeichen2,values)
		ss=log(0.01*ss+1) 
		q1=ss[1]
		q2=ss[2]
		sw2=(q2-q1)/30
             lauf=grid(#(i1,q1),#(sw1,sw2),#(31,31))
             q=lauf[,2]
            endif	
             i=lauf[,1]
	 break
       endsw 
      y=(log(s./k)+(i-q-v^2/2).*t)/(v.*sqrt(t))
    what = 0|0
    do 
     callput = "Call"|"Put" 
      what = selectitem (ahead, callput)
      if (what[1])
	opv = s.*exp(-q.*t).*cdfn(y+v.*sqrt(t))-k.*exp(-i.*t).*cdfn(y)
      endif 
      if (what[2])
        opv = k.*exp(-i.*t).*cdfn(-y)-s.*exp(-q.*t).*cdfn(-y-v.*sqrt(t))
      endif
    until (sum(what)==1)
      dat=lauf~opv
      gs = grsurface(lauf~opv) 
      box=grid(min(gs)',max(gs)'-min(gs)',2|2|2)
       m  = matrix(3)* 4
       formx= "%.1f"
       formy= "%.1f"
       formz= "%.1f"
      mi=min(gs)
      ma=max(gs)
      x = aseq(mi[,1],m[1],(ma[,1]-mi[,1])/m[1])
      x = x[2:m[1]]~(mi[,2:3].*matrix((m[1]-1)))
      xstr= string(formx, x[,1])
      setmaskp(x, 0, 0, 0)
      setmaskt(x, xstr, 0, 6, 10)
      y = aseq(mi[,2],m[2],(ma[,2]-mi[,2])/m[2])
      y = (mi[,1].*matrix((m[1]-1)))~y[2:m[2]]~(mi[,3].*matrix((m[2]-1)))
      ystr= string(formy, y[,2])
      setmaskp(y, 0, 0, 0)
      setmaskt(y, ystr, 0, 9, 10)
      z = aseq(mi[,3],m[3],(ma[,3]-mi[,3])/m[3])
      z = (mi[,1:2].*matrix((m[3]-1)))~z[2:m[3]]
      zstr= string(formz, z[,3])
      setmaskp(z, 0, 0, 0)
      setmaskt(z, zstr, 0, 9, 10)
      setmaskp(box,0,0,0)
      cube=(1~2~4~3~1)|(5~6~8~7~5)|(1~5~0~0~0)|(2~6~0~0~0)|(3~7~0~0~0)|(4~8~0~0~0)
      setmaskl(box,cube,0,1,1) 
      eckstr = "("+formx+","+formy+","+formz+")"
      coord = string(eckstr, box[,1], box[,2], box[,3])
      coord[4]  = " "
      coord[6:8]= " "
      setmaskt(box, coord, 0, 6, 10)
      axesoff() 
      d=createdisplay(1,1)
      show(d,1,1,gs,box,x, y, z) 
     endif
  
    if ( sum(sel)>2 ) 
       "You must not choose more than 2 parameters"
        end = 0
    endif
axeson()
;
until(end)
endp
