proc(fh,c)=interact(t,y,h,g,loc,incl,tg)
; -----------------------------------------------------------------
; Library     gam
; -----------------------------------------------------------------
;  See_also       intest, intest2d,
; -----------------------------------------------------------------
;   Macro         interact
; -----------------------------------------------------------------
;   Description   interact estimates a model with interaction terms.
;                 It is using the marginal integration estimator
;                 with a local polynomial smoother.
;                 For details see Sperlich, Tjostheim, Yang (1997)
; -----------------------------------------------------------------
;   Usage         {fh,c} = interact(t,y,h,g,loc,incl{,tg})
;   Input
;     Parameter   t
;     Definition      n x p matrix , the observed explanatory variable
;     Parameter   y
;     Definition      n x 1 vector , the observed
;                     response variables
;     Parameter   h
;     Definition      p x 1 or 1 x 1 matrix , chosen bandwidth for
;                     the directions of interest in the estimation step
;     Parameter   g
;     Definition      p x 1 or 1 x 1 matrix , chosen bandwidth for
;                     the directions not of interest in the estimation step
;     Parameter   loc
;     Definition      scalar in {0,1,2}, the degree of the local polynomial
;                     smoother
;     Parameter   incl
;     Definition      pp x 2 matrix, in the rows have to be all pairs
;                     of indices for interactions which shall be included
;                     in the model.
;     Parameter   tg
;     Definition      ng x p matrix , if grid is wished, tg is the grid on
;                     which we will estimate. Attention ! If you estimate on
;                     a grid, the estimates of the interaction functions
;                     are estimated up to a constant shift. Further, if you
;                     try to extrapolate, the estimate will be zero minus
;                     a centering constant.
;   Output
;     Parameter   mod.fh
;     Definition      n x (p+pp) matrix, estimates for the functions
;     Parameter   mod.c
;     Definition      scalar, the overall constant
; -----------------------------------------------------------------
;   Example    library("gam")
;              randomize(12345)
;              t     = grid(#(-0.9,-0.9),#(0.2,0.2),#(10,10))
;              n     = rows(t)
;              t     = t~(uniform(n)*2-1)
;              g1    = 2*t[,1]
;              g2    = t[,2]^2 - mean(t[,2]^2)
;              g3    = sin(3*t[,3])
;              g12   = t[,1].*t[,2]
;              y     = g1+g2+g3+g12+normal(n)*sqrt(0.5)
;              h     = #(0.9, 0.9, 0.9)
;              g     = #(1.0, 1.0, 1.0)
;              incl  = 1~2
;              f     = interact(t,y,h,g,1,incl)
;              library("graphic")
;              pic   = createdisplay(2,2)
;              dat11 = sort(t[,2]~g2)
;              datf1 = sort(t[,2]~f.fh[,2])
;              dat12 = sort(t[,3]~g3)
;              datf2 = sort(t[,3]~f.fh[,3])
;              setmaskp(dat11,1,3,8)
;              setmaskp(dat12,1,3,8)
;              setmaskp(datf1,4,3,8)
;              setmaskp(datf2,4,3,8)
;              setmaskl(datf1,(1:rows(datf1))',4,1,1)
;              setmaskl(datf2,(1:rows(datf2))',4,1,1)
;              show(pic,1,1,dat11,datf1)
;              show(pic,1,2,dat12,datf2)
;              dat21 = grsurface(t[,1:2]~g12)
;              dat22 = grsurface(t[,1:2]~f.fh[,4])
;              gc = grcube( dat21|dat22 )
;              show(pic,2,1,dat21,gc.box,gc.x,gc.y,gc.z,gc.c)
;              show(pic,2,2,dat22,gc.box,gc.x,gc.y,gc.z,gc.c)
; -----------------------------------------------------------------
;   Result    function estimates
; -----------------------------------------------------------------
;   Author    Sperlich   970721
; -----------------------------------------------------------------

 c = mean(y)
 p = cols(t)
 n = rows(t)
 if (exist(tg))
    ng = rows(tg)
 else
    ng = n
 endif
 pp  = rows(incl)
 o = sort(t[,1]~(1:n))[,2]
 ro = sort(o~(1:n))[,2]
 ys = y[o]
 ts = t[o]
 if (rows(g)<>p)             /* reshape g to matrix */
   errtext = "rows of g didn't fit: "+string("%1.4f",g[1,1])+" assumed"
   warning(rows(g)>1,errtext)
   g = matrix(p)*g[1,1]
 endif
 if (rows(h)<>p)            /* reshape h to matrix */
   errtext = "rows of h didn't fit: "+string("%1.4f",h[1,1])+" assumed"
   warning(rows(h)>1,errtext)
   h = matrix(p)*h[1,1]
 endif
;
; inner grid
; -----------------------------------------------------------------
 innergrid = (n>40)
 if (innergrid)
   nig = (n>499)*40+(n<500)*25+10
   tmin = min(t)
   tmax = max(t)
   range = tmax-tmin
   ig = tmin + (0:4)*(0.02*range)
   ig = ig | (tmin+range*0.1) + (0:nig-11)*(0.8*range/(nig-11))
   ig = ig | (tmin+range*23/25) + (0:4)*(0.02*range)
 else
   nig = n
   ig = t
 endif
 fhig = matrix(nig)*0
 fh = matrix(ng,p+pp)*0
 f  = matrix(n)*0
 const = matrix(p)*0
;
; estimation routine
; -----------------------------------------------------------------
 j = 1
 while (j<=p)
   hs = g
   hs[j] = h[j]
   if (loc==0)
     ys = ys~matrix(n)
      i = 1
      while (i<=nig)
        test = ts
        test[,j] = ig[i,j].*matrix(n)
        r = sker(ts,hs',"qua",ys,test)
        r = paf(r,r[,2].<>0)
        mh = r[,1]./r[,2]
        fhig[i] = mean(mh,1)
        i = i + 1
      endo
      ys = ys[,1]
   else
     i = 1
     while (i<=nig)
       test = ts
       test[,j] = ig[i,j]*matrix(n)
       ma = locpol(ts,test,ys,hs,(loc-1))
         sel = isNumber(ma[,1,1])
         if (sum(sel,1)<>n)
           ma = paf(ma,sel)
         endif
         fhig[i] = mean(ma[,1,1],1)
       i = i + 1
     endo
   endif
   if (innergrid)
     ig0 = ig[1:nig-1,j]
     ig1 = ig[2:nig,j]
     s = (t[,j]>=ig0')&&(t[,j]<ig1')
     f0 = fhig[1:nig-1]
     f1 = fhig[2:nig]
     f  = s*f0 + s*((f1-f0)/(ig1-ig0)) .* (t[,j]-s*ig0)
     upper = (t[,j]==tmax[,j])
     if (sum(upper)>0)
       f[paf((upper.*(1:n)),upper)] = fhig[nig]
     endif
   else
     f = fhig
   endif
   sel = isNumber(f)
   const[j] = mean(paf(f,sel))
   if (exist(tg))
      ig0 = ig[1:nig-1,j]
      ig1 = ig[2:nig,j]
      s = (tg[,j]>=ig0')&&(tg[,j]<ig1')
      f0 = fhig[1:nig-1]
      f1 = fhig[2:nig]
      fh[,j] = s*f0 + s*((f1-f0)/(ig1-ig0)) .* (tg[,j]-s*ig0)
      upper = (tmax[,j]==tg[,j])
      if (sum(upper)>0)
        fh[paf((upper.*(1:ng)),upper),j] = fhig[nig]
      endif
   else
     fh[,j] = f
   endif
   j = j + 1
 endo
;
if (exist(tg)==0)
  tg = t
endif
 j = 1
 while (j<=pp)
   hs = g
   hs[(incl[j,]')] = h[(incl[j,]')]
   if (loc==0)
     ys = ys~matrix(n)
     if (p>2)
      m = 1
      while (m<=ng)
        test = ts
        test[,(incl[j,]')] = tg[m,(incl[j,]')].*matrix(n)
        r = sker(ts,hs',"qua",ys,test)
        r = paf(r,r[,2].<>0)
        mh = r[,1]./r[,2]
        fh[m,p+j] = mean(mh,1)
        m = m + 1
      endo
     else
       r = sker(ts,h',"qua",ys)[ro,]
       fh[,p+j] = r[,1]./r[,2]
     endif
     ys = ys[,1]
   else
     if (p>2)
      m = 1
      while (m.<=ng)
        test = ts
        test[,(incl[j,]')] = tg[m,(incl[j,]')].*matrix(n)
        ma = locpol(ts,test,ys,hs,(loc-1))[,1,1]
        sel = isNumber(ma)
        if (sum(sel,1)<>n)
          ma = paf(ma,sel)
        endif
        fh[m,p+j] = mean(ma,1)
        m = m+1
      endo
     else
       fh[,p+j] = locpol(ts,ts,ys,h,(loc-1))[ro,1,1]
     endif
   endif
     fh[,p+j] = fh[,p+j] - sum(fh[,(incl[j,]')],2) +c
     sel = isNumber(fh[,p+j])
     fh[,p+j] = fh[,p+j].-mean(paf(fh[,p+j],sel))/2
     j = j+1
   endo
;
  fh[,1:p] = fh[,1:p].- const'
;
endp
