proc (y) = isNumber (x)
; -----------------------------------------------------------------
; Library        xplore
; -----------------------------------------------------------------
;  See_also      countNaN countNotNumber isInf isNaN
; -----------------------------------------------------------------
;  Keywords      missing values, infinite values
; -----------------------------------------------------------------
;   Macro        isNumber
; -----------------------------------------------------------------
;   Description  Determines whether elements of an array are
;                usual figures or not (NaN, Inf, -Inf).
; -----------------------------------------------------------------
;   Usage        y = isNumber (x)
;   Input
;     Parameter  x  
;     Definition array
;   Output
;     Parameter  y  
;     Definition array with 1 (true, is NaN) or 0 (false)
; -----------------------------------------------------------------
;   Example   library("xplore")
;             x = #(0/0, 1/0, -1/0, 1)
;             x ~ isNumber (x)
; -----------------------------------------------------------------
;   Result    
;             Contents of _tmp
;	      [1,]   NaN     0 
;	      [2,]   Inf     0 
;	      [3,]  -Inf     0 
;	      [4,]     1     1 
; -----------------------------------------------------------------
;   Author    TTK, 960423
; -----------------------------------------------------------------

  y = abs(x) < Inf
endp

